/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.common.config.IEClientConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.joml.Quaternionf;

public abstract class IEBlockEntityRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private static final Map<Direction, Quaternionf> ROTATE_FOR_FACING = (Map)Util.make(new EnumMap(Direction.class), m -> {
        for (Direction facing : DirectionUtils.BY_HORIZONTAL_INDEX) {
            m.put(facing, new Quaternionf().rotateY((float)Math.PI / 180 * (180.0f - facing.toYRot())));
        }
    });

    public int getViewDistance() {
        double increase = (Double)IEClientConfig.increasedTileRenderdistance.get();
        return (int)((double)super.getViewDistance() * increase);
    }

    protected static void rotateForFacingNoCentering(PoseStack stack, Direction facing) {
        stack.mulPose(ROTATE_FOR_FACING.get(facing));
    }

    protected static void rotateForFacing(PoseStack stack, Direction facing) {
        stack.translate(0.5, 0.5, 0.5);
        IEBlockEntityRenderer.rotateForFacingNoCentering(stack, facing);
        stack.translate(-0.5, -0.5, -0.5);
    }
}

