/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.client.models.BakedIEModel;
import blusunrize.immersiveengineering.client.utils.ModelUtils;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.RenderTypeGroup;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class ModelConfigurableSides
extends BakedIEModel {
    private static final HashMap<String, ITextureNamer> TYPES = new HashMap();
    private final LoadingCache<Map<Direction, IEEnums.IOSideConfig>, Map<Direction, BakedQuad>> modelCache = CacheBuilder.newBuilder().expireAfterAccess(60L, TimeUnit.SECONDS).build(CacheLoader.from(key -> {
        EnumMap<Direction, TextureAtlasSprite> tex = new EnumMap<Direction, TextureAtlasSprite>(Direction.class);
        for (Direction d : DirectionUtils.VALUES) {
            tex.put(d, this.textures.get(d).get(key.get(d)));
        }
        return ModelConfigurableSides.bakeQuads(tex);
    }));
    final String name;
    public Map<Direction, Map<IEEnums.IOSideConfig, TextureAtlasSprite>> textures;
    private final RenderTypeGroup renderTypes;
    static final ItemTransforms defaultTransforms;

    public ModelConfigurableSides(String name, Map<Direction, Map<IEEnums.IOSideConfig, TextureAtlasSprite>> textures, RenderTypeGroup renderTypes) {
        this.name = name;
        this.textures = textures;
        this.renderTypes = renderTypes;
    }

    @Override
    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, @Nullable RenderType layer) {
        EnumMap<Direction, IEEnums.IOSideConfig> config;
        if (side == null) {
            return ImmutableList.of();
        }
        if (extraData.has(IEProperties.Model.SIDECONFIG)) {
            config = (EnumMap<Direction, IEEnums.IOSideConfig>)extraData.get(IEProperties.Model.SIDECONFIG);
        } else {
            config = new EnumMap<Direction, IEEnums.IOSideConfig>(Direction.class);
            for (Direction d : DirectionUtils.VALUES) {
                config.put(d, IEEnums.IOSideConfig.NONE);
            }
        }
        assert (config != null);
        return ImmutableList.of((Object)((BakedQuad)((Map)this.modelCache.getUnchecked(config)).get(side)));
    }

    @Nonnull
    public ModelData getModelData(@Nonnull BlockAndTintGetter world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull ModelData tileData) {
        ModelData.Builder data = super.getModelData(world, pos, state, tileData).derive();
        BlockEntity te = world.getBlockEntity(pos);
        if (te instanceof IEBlockInterfaces.IConfigurableSides) {
            IEBlockInterfaces.IConfigurableSides confTE = (IEBlockInterfaces.IConfigurableSides)te;
            EnumMap<Direction, IEEnums.IOSideConfig> conf = new EnumMap<Direction, IEEnums.IOSideConfig>(Direction.class);
            for (Direction d : DirectionUtils.VALUES) {
                conf.put(d, confTE.getSideConfig(d));
            }
            data.with(IEProperties.Model.SIDECONFIG, conf);
        }
        return data.build();
    }

    private static Map<Direction, BakedQuad> bakeQuads(Map<Direction, TextureAtlasSprite> sprites) {
        EnumMap<Direction, BakedQuad> quads = new EnumMap<Direction, BakedQuad>(Direction.class);
        Vec3[] vertices = new Vec3[]{new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 1.0), new Vec3(1.0, 0.0, 1.0), new Vec3(1.0, 0.0, 0.0)};
        ModelConfigurableSides.addQuad(quads, sprites, Direction.DOWN, vertices, new double[]{0.0, 16.0, 16.0, 0.0});
        vertices = new Vec3[]{new Vec3(0.0, 1.0, 0.0), new Vec3(0.0, 1.0, 1.0), new Vec3(1.0, 1.0, 1.0), new Vec3(1.0, 1.0, 0.0)};
        ModelConfigurableSides.addQuad(quads, sprites, Direction.UP, vertices, new double[]{0.0, 0.0, 16.0, 16.0});
        vertices = new Vec3[]{new Vec3(1.0, 0.0, 0.0), new Vec3(1.0, 1.0, 0.0), new Vec3(0.0, 1.0, 0.0), new Vec3(0.0, 0.0, 0.0)};
        ModelConfigurableSides.addQuad(quads, sprites, Direction.NORTH, vertices, new double[]{0.0, 16.0, 16.0, 0.0});
        vertices = new Vec3[]{new Vec3(1.0, 0.0, 1.0), new Vec3(1.0, 1.0, 1.0), new Vec3(0.0, 1.0, 1.0), new Vec3(0.0, 0.0, 1.0)};
        ModelConfigurableSides.addQuad(quads, sprites, Direction.SOUTH, vertices, new double[]{16.0, 16.0, 0.0, 0.0});
        vertices = new Vec3[]{new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 1.0, 0.0), new Vec3(0.0, 1.0, 1.0), new Vec3(0.0, 0.0, 1.0)};
        ModelConfigurableSides.addQuad(quads, sprites, Direction.WEST, vertices, new double[]{0.0, 16.0, 16.0, 0.0});
        vertices = new Vec3[]{new Vec3(1.0, 0.0, 0.0), new Vec3(1.0, 1.0, 0.0), new Vec3(1.0, 1.0, 1.0), new Vec3(1.0, 0.0, 1.0)};
        ModelConfigurableSides.addQuad(quads, sprites, Direction.EAST, vertices, new double[]{16.0, 16.0, 0.0, 0.0});
        return quads;
    }

    private static void addQuad(Map<Direction, BakedQuad> out, Map<Direction, TextureAtlasSprite> sprites, Direction side, Vec3[] vertices, double[] uv) {
        out.put(side, ModelUtils.createBakedQuad(vertices, side, sprites.get(side), uv, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, side.getAxisDirection() == Direction.AxisDirection.NEGATIVE));
    }

    public boolean useAmbientOcclusion() {
        return true;
    }

    public boolean isGui3d() {
        return true;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite getParticleIcon() {
        return this.textures.get(Direction.DOWN).get((Object)IEEnums.IOSideConfig.NONE);
    }

    @Nonnull
    public ItemTransforms getTransforms() {
        return defaultTransforms;
    }

    @Nonnull
    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }

    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{this.renderTypes.block()});
    }

    public List<RenderType> getRenderTypes(ItemStack itemStack, boolean fabulous) {
        return List.of(fabulous ? this.renderTypes.entityFabulous() : this.renderTypes.entity());
    }

    static {
        for (Type type : Type.values()) {
            TYPES.put(type.getName(), type.nameMapper);
        }
        defaultTransforms = new ItemTransforms(new ItemTransform(new Vector3f(75.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.25f, 0.0f), new Vector3f(0.375f, 0.375f, 0.375f)), new ItemTransform(new Vector3f(75.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.15625f, 0.0f), new Vector3f(0.375f, 0.375f, 0.375f)), new ItemTransform(new Vector3f(0.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.4f, 0.4f, 0.4f)), new ItemTransform(new Vector3f(0.0f, 225.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.4f, 0.4f, 0.4f)), new ItemTransform(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f)), new ItemTransform(new Vector3f(30.0f, 225.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.625f, 0.625f, 0.625f)), new ItemTransform(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.1875f, 0.0f), new Vector3f(0.25f, 0.25f, 0.25f)), new ItemTransform(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.5f, 0.5f, 0.5f)));
    }

    public static enum Type {
        SIDE_TOP_BOTTOM(new ITextureNamer(){

            @Override
            public String nameFromSide(Direction side, IEEnums.IOSideConfig cfg) {
                return side.getAxis() == Direction.Axis.Y ? side.getSerializedName() : "side";
            }
        }),
        SIDE_VERTICAL(new ITextureNamer(){

            @Override
            public String nameFromSide(Direction side, IEEnums.IOSideConfig cfg) {
                return side.getAxis() == Direction.Axis.Y ? "up" : "side";
            }
        }),
        VERTICAL(new ITextureNamer(){

            @Override
            public String nameFromSide(Direction side, IEEnums.IOSideConfig cfg) {
                return side.getAxis() == Direction.Axis.Y ? "up" : "side";
            }

            @Override
            public String nameFromCfg(Direction side, IEEnums.IOSideConfig cfg) {
                return side.getAxis() == Direction.Axis.Y ? cfg.getTextureName() : null;
            }
        }),
        ALL_SAME_TEXTURE(new ITextureNamer(){

            @Override
            public String nameFromSide(Direction side, IEEnums.IOSideConfig cfg) {
                return "side";
            }
        });

        private final ITextureNamer nameMapper;

        private Type(ITextureNamer nameMapper) {
            this.nameMapper = nameMapper;
        }

        public String getName() {
            return this.name().toLowerCase(Locale.US);
        }
    }

    static interface ITextureNamer {
        default public String getTextureName(Direction side, IEEnums.IOSideConfig cfg) {
            String s = this.nameFromSide(side, cfg);
            String c = this.nameFromCfg(side, cfg);
            if (s != null && c != null) {
                return s + "_" + c;
            }
            if (s != null) {
                return s;
            }
            if (c != null) {
                return c;
            }
            return "";
        }

        default public String nameFromSide(Direction side, IEEnums.IOSideConfig cfg) {
            return side.getSerializedName();
        }

        default public String nameFromCfg(Direction side, IEEnums.IOSideConfig cfg) {
            return cfg.getTextureName();
        }
    }

    private record ConfigSidesModelBase(String name, String type, Map<String, Material> textures) implements IUnbakedGeometry<ConfigSidesModelBase>
    {
        public BakedModel bake(IGeometryBakingContext owner, ModelBaker bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides) {
            EnumMap<Direction, Map<IEEnums.IOSideConfig, TextureAtlasSprite>> tex = new EnumMap<Direction, Map<IEEnums.IOSideConfig, TextureAtlasSprite>>(Direction.class);
            for (Direction f : DirectionUtils.VALUES) {
                EnumMap<IEEnums.IOSideConfig, TextureAtlasSprite> forSide = new EnumMap<IEEnums.IOSideConfig, TextureAtlasSprite>(IEEnums.IOSideConfig.class);
                for (IEEnums.IOSideConfig cfg : IEEnums.IOSideConfig.values()) {
                    Material rl = this.textures.get(f.getSerializedName() + "_" + cfg.getTextureName());
                    if (rl == null) continue;
                    forSide.put(cfg, spriteGetter.apply(rl));
                }
                tex.put(f, forSide);
            }
            ResourceLocation renderTypeName = Objects.requireNonNullElseGet(owner.getRenderTypeHint(), () -> ResourceLocation.withDefaultNamespace((String)"solid"));
            return new ModelConfigurableSides(this.name, tex, owner.getRenderType(renderTypeName));
        }
    }

    public static class Loader
    implements IGeometryLoader<ConfigSidesModelBase> {
        public static ResourceLocation NAME = IEApi.ieLoc("conf_sides");

        @Nonnull
        public ConfigSidesModelBase read(JsonObject modelContents, @Nonnull JsonDeserializationContext deserializationContext) {
            String name = modelContents.get("base_name").getAsString();
            String type = modelContents.get("type").getAsString();
            ImmutableMap.Builder builder = ImmutableMap.builder();
            ITextureNamer namer = TYPES.get(type);
            for (Direction f : DirectionUtils.VALUES) {
                for (IEEnums.IOSideConfig cfg : IEEnums.IOSideConfig.values()) {
                    String key = f.getSerializedName() + "_" + cfg.getTextureName();
                    String tex = name + "_" + namer.getTextureName(f, cfg);
                    builder.put((Object)key, (Object)new Material(InventoryMenu.BLOCK_ATLAS, ResourceLocation.parse((String)tex)));
                }
            }
            return new ConfigSidesModelBase(name, type, (Map<String, Material>)builder.build());
        }
    }
}

