/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.api.tool.IConfigurableTool;
import blusunrize.immersiveengineering.client.gui.IEContainerScreen;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonCheckbox;
import blusunrize.immersiveengineering.client.gui.elements.GuiSliderIE;
import java.util.function.Function;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public abstract class ToolModificationScreen<C extends AbstractContainerMenu>
extends IEContainerScreen<C> {
    CompoundTag lastMessage;

    public ToolModificationScreen(C inventorySlotsIn, Inventory inv, Component title, ResourceLocation background) {
        super(inventorySlotsIn, inv, title, background);
    }

    @Override
    public void init() {
        this.clearWidgets();
        super.init();
        Slot s = this.menu.getSlot(0);
        if (s.hasItem() && s.getItem().getItem() instanceof IConfigurableTool) {
            IConfigurableTool.ToolConfig.ToolConfigFloat[] floatArray;
            ItemStack stack = s.getItem();
            IConfigurableTool tool = (IConfigurableTool)stack.getItem();
            IConfigurableTool.ToolConfig.ToolConfigBoolean[] boolArray = tool.getBooleanOptions(stack);
            if (boolArray != null) {
                for (IConfigurableTool.ToolConfig.ToolConfigBoolean b : boolArray) {
                    this.addRenderableWidget((GuiEventListener)new GuiButtonCheckbox(this.leftPos + b.x, this.topPos + b.y, (Component)Component.literal((String)tool.fomatConfigName(stack, b)), () -> b.value, btn -> this.sendChange((Boolean)btn.getState() == false, b.name, ByteTag::valueOf)));
                }
            }
            if ((floatArray = tool.getFloatOptions(stack)) != null) {
                for (IConfigurableTool.ToolConfig.ToolConfigFloat f : floatArray) {
                    this.addRenderableWidget((GuiEventListener)new GuiSliderIE(this.leftPos + f.x, this.topPos + f.y, 80, tool.fomatConfigName(stack, f), f.min, f.max, f.value, value -> this.sendChange(Float.valueOf(value), f.name, FloatTag::valueOf)));
                }
            }
        }
    }

    private <T> void sendChange(T value, String optionName, Function<T, Tag> makeTag) {
        Slot s = this.menu.getSlot(0);
        Item item = s.getItem().getItem();
        if (item instanceof IConfigurableTool) {
            IConfigurableTool tool = (IConfigurableTool)item;
            ItemStack stack = s.getItem();
            CompoundTag message = new CompoundTag();
            message.put(optionName, makeTag.apply(value));
            tool.applyConfigOption(stack, optionName, value);
            if (!message.equals((Object)this.lastMessage)) {
                this.sendMessage(message);
            }
            this.lastMessage = message;
        }
    }

    protected abstract void sendMessage(CompoundTag var1);
}

