/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.client.gui.IEContainerScreen;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonIE;
import blusunrize.immersiveengineering.client.gui.elements.ITooltipWidget;
import blusunrize.immersiveengineering.client.gui.info.EnergyInfoArea;
import blusunrize.immersiveengineering.client.gui.info.InfoArea;
import blusunrize.immersiveengineering.client.gui.info.TooltipArea;
import blusunrize.immersiveengineering.common.gui.RadioTowerMenu;
import blusunrize.immersiveengineering.common.gui.sync.GetterAndSetter;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector4f;

public class RadioTowerScreen
extends IEContainerScreen<RadioTowerMenu> {
    private static final ResourceLocation TEXTURE = RadioTowerScreen.makeTextureLocation("radio_tower");
    private static final GuiButtonIE.ButtonTexture SAVE = new GuiButtonIE.ButtonTexture(IEApi.ieLoc("radio_tower/save"), IEApi.ieLoc("radio_tower/save_hovered"));
    private static final ResourceLocation SAVE_COLOR = IEApi.ieLoc("radio_tower/save_color");

    public RadioTowerScreen(RadioTowerMenu container, Inventory inventoryPlayer, Component title) {
        super(container, inventoryPlayer, title, TEXTURE);
        this.imageWidth = 240;
        this.imageHeight = 150;
        this.inventoryLabelY = 116;
    }

    @Override
    @Nonnull
    protected List<InfoArea> makeInfoAreas() {
        return ImmutableList.of((Object)new EnergyInfoArea(this.leftPos + 221, this.topPos + 10, ((RadioTowerMenu)this.menu).energy), (Object)new TooltipArea(new Rect2i(this.leftPos + 78, this.topPos + 40, 64, 16), () -> Component.translatable((String)"gui.immersiveengineering.config.radio_tower.frequency")), (Object)new TooltipArea(new Rect2i(this.leftPos + 175, this.topPos + 126, 55, 16), () -> Component.translatable((String)"gui.immersiveengineering.config.radio_tower.range")));
    }

    @Override
    protected void gatherAdditionalTooltips(int mouseX, int mouseY, Consumer<Component> addLine, Consumer<Component> addGray) {
        super.gatherAdditionalTooltips(mouseX, mouseY, addLine, addGray);
    }

    @Override
    protected void drawContainerBackgroundPre(@Nonnull GuiGraphics graphics, float f, int mx, int my) {
        Font font = this.getMinecraft().font;
        graphics.drawCenteredString(font, I18n.get((String)"gui.immersiveengineering.config.radio_tower.range_m", (Object[])new Object[]{Utils.formatDouble(((RadioTowerMenu)this.menu).range.get() * 16, "##,###")}), this.getGuiLeft() + 202, this.getGuiTop() + 130, 0xFFFFFF);
        int centerX = this.getGuiLeft() + 202;
        int centerY = this.getGuiTop() + 96;
        int radius = 25;
        for (Vec3 pos : ((RadioTowerMenu)this.menu).otherComponents.get().positions()) {
            int xx = centerX + (int)Math.ceil(pos.x * 25.0);
            int yy = centerY + (int)Math.ceil(pos.y * 25.0);
            graphics.fill(xx, yy, xx + 1, yy + 1, -1);
        }
    }

    @Override
    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.drawString(this.font, I18n.get((String)"gui.immersiveengineering.config.radio_tower.saved_frequencies", (Object[])new Object[0]), 14, 61, 2955776, false);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double distX, double distY) {
        if (this.getFocused() != null && this.isDragging() && button == 0) {
            return this.getFocused().mouseDragged(mouseX, mouseY, button, distX, distY);
        }
        return super.mouseDragged(mouseX, mouseY, button, distX, distY);
    }

    @Override
    public void init() {
        super.init();
        this.clearWidgets();
        this.addRenderableWidget((GuiEventListener)new FrequencySlider(this.getGuiLeft() + 8, this.getGuiTop() + 8, 128, 384, ((RadioTowerMenu)this.menu).frequency, this::sendFrequencyToServer));
        for (DyeColor color : DyeColor.values()) {
            int ordinal = color.ordinal();
            this.addRenderableWidget((GuiEventListener)new SaveButton(this.getGuiLeft() + 12 + ordinal % 8 * 20, this.getGuiTop() + 78 + ordinal / 8 * 22, color, () -> ((RadioTowerMenu)this.menu).savedFrequencies.get()[ordinal], button -> {
                int[] saved = ((RadioTowerMenu)this.menu).savedFrequencies.get();
                if (Screen.hasShiftDown()) {
                    ((RadioTowerMenu)this.menu).frequency.set(saved[ordinal]);
                    this.sendFrequencyToServer(saved[ordinal]);
                } else {
                    saved[ordinal] = ((RadioTowerMenu)this.menu).frequency.get();
                    ((RadioTowerMenu)this.menu).savedFrequencies.set(saved);
                    this.sendSavedFrequenciesToServer(saved);
                }
            }));
        }
    }

    private void sendFrequencyToServer(int frq) {
        CompoundTag message = new CompoundTag();
        message.putInt("frequency", frq);
        this.sendUpdateToServer(message);
    }

    private void sendSavedFrequenciesToServer(int[] frq) {
        CompoundTag message = new CompoundTag();
        message.putIntArray("savedFrequencies", frq);
        this.sendUpdateToServer(message);
    }

    private static class FrequencySlider
    extends AbstractWidget {
        private final int minValue;
        private final int maxValue;
        private final GetterAndSetter<Integer> value;
        private final Consumer<Integer> sendToServer;
        private static final DecimalFormat FRQ_FORMAT = new DecimalFormat("###");

        public FrequencySlider(int x, int y, int min, int max, GetterAndSetter<Integer> value, Consumer<Integer> sendToServer) {
            super(x, y, 204, 48, (Component)Component.empty());
            this.minValue = min;
            this.maxValue = max;
            this.value = value;
            this.sendToServer = sendToServer;
        }

        private int getInnerX() {
            return this.getX() + 12;
        }

        private int getInnerWidth() {
            return this.getWidth() - 24;
        }

        private int mouseToValue(double mouseX) {
            double relativeValue = (mouseX - (double)this.getInnerX()) / (double)this.getInnerWidth();
            return (int)Math.round((double)this.minValue + relativeValue * (double)(this.maxValue - this.minValue));
        }

        private int valueToOffset(int value) {
            return (int)Math.round((double)(value - this.minValue) / (double)(this.maxValue - this.minValue) * (double)this.getInnerWidth());
        }

        private void setValue(int newValue) {
            newValue = Mth.clamp((int)newValue, (int)this.minValue, (int)this.maxValue);
            this.value.set(newValue);
            this.sendToServer.accept(newValue);
        }

        protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            Minecraft minecraft = Minecraft.getInstance();
            graphics.setColor(1.0f, 1.0f, 1.0f, this.alpha);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            graphics.blit(TEXTURE, this.getX(), this.getY(), 0, 150, this.width, this.height);
            if (this.isHoveredOrFocused()) {
                graphics.blit(TEXTURE, this.getX(), this.getY(), 0, 150 + this.height, this.width, 32);
            }
            int cursorU = this.isHoveredOrFocused() ? 243 : 240;
            graphics.blit(TEXTURE, this.getInnerX() + this.valueToOffset(this.value.get()) - 1, this.getY() + 19, cursorU, 0, 3, 6);
            graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            for (int step = this.minValue; step <= this.maxValue; step += 64) {
                int offset = this.valueToOffset(step);
                graphics.drawCenteredString(minecraft.font, FRQ_FORMAT.format(step), this.getInnerX() + offset, this.getY() + 4, 0xFFFFFF);
                int n = this.getInnerX() + offset;
                int n2 = this.getY();
                Objects.requireNonNull(minecraft.font);
                int n3 = n2 + 9 + 4;
                int n4 = this.getInnerX() + offset + 1;
                int n5 = this.getY();
                Objects.requireNonNull(minecraft.font);
                graphics.fill(n, n3, n4, n5 + 9 + 8, -1);
            }
            graphics.drawCenteredString(minecraft.font, I18n.get((String)"gui.immersiveengineering.config.radio_tower.khz", (Object[])new Object[]{this.value.get()}), this.getX() + 100, this.getY() + 34, 0xFFFFFF);
        }

        protected void onDrag(double mouseX, double mouseY, double p_93593_, double p_93594_) {
            this.setValue(this.mouseToValue(mouseX));
        }

        public void onClick(double mouseX, double mouseY, int button) {
            this.setValue(this.mouseToValue(mouseX));
        }

        public boolean mouseScrolled(double mouseX, double mouseY, double scroll1, double scroll2) {
            if (this.isHovered()) {
                this.setValue(this.value.get() + (scroll2 > 0.0 ? 1 : -1));
                return true;
            }
            return false;
        }

        protected void updateWidgetNarration(NarrationElementOutput graphics) {
        }
    }

    private static class SaveButton
    extends GuiButtonIE
    implements ITooltipWidget {
        private final DyeColor color;
        private final IntSupplier frequency;

        public SaveButton(int x, int y, DyeColor color, IntSupplier frequency, GuiButtonIE.IIEPressable handler) {
            super(x, y, 17, 17, (Component)Component.empty(), SAVE, handler);
            this.color = color;
            this.frequency = frequency;
        }

        @Override
        public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            super.renderWidget(graphics, mouseX, mouseY, partialTicks);
            Vector4f rgb = Utils.vec4fFromDye(this.color);
            graphics.setColor(rgb.x, rgb.y, rgb.z, 1.0f);
            graphics.blitSprite(SAVE_COLOR, this.getX(), this.getY(), this.width, this.height);
            graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        }

        @Override
        public void gatherTooltip(int mouseX, int mouseY, List<Component> tooltip) {
            tooltip.add((Component)Component.translatable((String)("color.minecraft." + this.color.getName())));
            tooltip.add((Component)Component.translatable((String)"gui.immersiveengineering.config.radio_tower.khz", (Object[])new Object[]{this.frequency.getAsInt()}).withStyle(ChatFormatting.GRAY));
            tooltip.add((Component)Component.translatable((String)"gui.immersiveengineering.config.radio_tower.save").withStyle(ChatFormatting.DARK_GRAY));
            tooltip.add((Component)Component.translatable((String)"gui.immersiveengineering.config.radio_tower.load").withStyle(ChatFormatting.DARK_GRAY));
        }
    }
}

