/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.tool.MachineInterfaceHandler;
import blusunrize.immersiveengineering.client.gui.ClientBlockEntityScreen;
import blusunrize.immersiveengineering.client.gui.IEContainerScreen;
import blusunrize.immersiveengineering.client.gui.ItemBatcherScreen;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonDyeColor;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonIE;
import blusunrize.immersiveengineering.client.gui.elements.GuiSelectBox;
import blusunrize.immersiveengineering.client.gui.elements.ITooltipWidget;
import blusunrize.immersiveengineering.client.gui.elements.WidgetRowList;
import blusunrize.immersiveengineering.common.blocks.wooden.MachineInterfaceBlockEntity;
import blusunrize.immersiveengineering.common.network.MessageBlockEntitySync;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.DyeColor;
import net.neoforged.neoforge.network.PacketDistributor;

public class MachineInterfaceScreen
extends ClientBlockEntityScreen<MachineInterfaceBlockEntity> {
    public static final ResourceLocation TEXTURE = IEContainerScreen.makeTextureLocation("machine_interface");
    private static final GuiButtonIE.ButtonTexture COLOR_BUTTON = new GuiButtonIE.ButtonTexture(IEApi.ieLoc("machine_interface/color_button"));
    private static final GuiButtonIE.ButtonTexture ADD_BUTTON = new GuiButtonIE.ButtonTexture(IEApi.ieLoc("machine_interface/add_button"));
    private static final GuiButtonIE.ButtonTexture UP = new GuiButtonIE.ButtonTexture(IEApi.ieLoc("machine_interface/up"), IEApi.ieLoc("machine_interface/up_hovered"));
    private static final GuiButtonIE.ButtonTexture DOWN = new GuiButtonIE.ButtonTexture(IEApi.ieLoc("machine_interface/down"), IEApi.ieLoc("machine_interface/down_hovered"));
    private static final GuiButtonIE.ButtonTexture DELETE = new GuiButtonIE.ButtonTexture(IEApi.ieLoc("machine_interface/delete"), IEApi.ieLoc("machine_interface/delete_hovered"));
    private static final int GUI_WIDTH_LEFT = 23;
    private static final int GUI_WIDTH_MIDDLE = 16;
    private static final int GUI_WIDTH_RIGHT = 41;
    private static final int GUI_WIDTH_SLOT = 28;
    private MachineInterfaceHandler.MachineCheckImplementation<?>[] availableChecks;
    private List<MachineInterfaceBlockEntity.MachineInterfaceConfig<?>> configList;
    private static final MachineInterfaceBlockEntity.MachineInterfaceConfig<?> FALLBACK_CONFIG = new MachineInterfaceBlockEntity.MachineInterfaceConfig(0, 0, DyeColor.WHITE);
    private WidgetRowList rowList;
    private static final int MAX_SCROLL = 6;
    private static final int ROW_HEIGHT = 24;
    private int middleSegmentCount;

    public MachineInterfaceScreen(MachineInterfaceBlockEntity blockEntity, Component title) {
        super(blockEntity, title);
        this.xSize = 144;
        this.ySize = 186;
    }

    @Override
    public void init() {
        super.init();
        this.clearWidgets();
        MachineInterfaceHandler.IMachineInterfaceConnection attachedMachine = ((MachineInterfaceBlockEntity)this.blockEntity).machine.getCapability();
        if (attachedMachine != null) {
            this.availableChecks = attachedMachine.getAvailableChecks();
            int longestCheck = 0;
            int longestOption = 0;
            for (MachineInterfaceHandler.MachineCheckImplementation<?> availableCheck : this.availableChecks) {
                longestCheck = Math.max(longestCheck, this.font.width((FormattedText)availableCheck.getName()));
                for (MachineInterfaceHandler.CheckOption<?> option : availableCheck.options()) {
                    longestOption = Math.max(longestOption, this.font.width((FormattedText)option.getName()));
                }
            }
            int finalLongestCheck = longestCheck;
            int finalLongestOption = longestOption;
            this.rowList = new WidgetRowList(this.guiLeft + 10, this.guiTop + 10, 24, 6, (x, y, idx) -> new GuiButtonDelete(x, y, btn -> this.removeConfigurationRow(idx.getAsInt())), (x, y, idx) -> new GuiButtonDyeColor(x + 4, y, 16, 16, () -> this.getConfigSafe(idx).getOutputColor().getId(), COLOR_BUTTON, btn -> this.sendConfig(idx.getAsInt(), this.getConfigSafe(idx).setOutputColor((DyeColor)btn.getNextState())), ItemBatcherScreen::gatherRedstoneTooltip), (x, y, idx) -> new GuiSelectBox<MachineInterfaceHandler.MachineCheckImplementation>(x + 4, y, finalLongestCheck, () -> this.availableChecks, () -> this.getConfigSafe(idx).getSelectedCheck(), MachineInterfaceHandler.MachineCheckImplementation::getName, btn -> {
                this.sendConfig(idx.getAsInt(), this.getConfigSafe(idx).setSelectedCheck(btn.getClickedState()).setSelectedOption(0));
                Object patt0$temp = this.renderables.get(this.renderables.indexOf(btn) + 1);
                if (patt0$temp instanceof GuiSelectBox) {
                    GuiSelectBox optionButton = (GuiSelectBox)patt0$temp;
                    optionButton.recalculateOptionsAndSize();
                }
            }), (x, y, idx) -> new GuiSelectBox<MachineInterfaceHandler.CheckOption>(x + 4, y, finalLongestOption, () -> this.availableChecks[this.getConfigSafe(idx).getSelectedCheck()].options(), () -> this.getConfigSafe(idx).getSelectedOption(), MachineInterfaceHandler.CheckOption::getName, btn -> this.sendConfig(idx.getAsInt(), this.getConfigSafe(idx).setSelectedOption(btn.getClickedState()))));
            this.configList = new ArrayList(((MachineInterfaceBlockEntity)this.blockEntity).configurations);
            this.configList.forEach(c -> this.rowList.addRow(x$0 -> {
                AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
            }));
            this.middleSegmentCount = (int)Math.ceil((float)(this.rowList.getRowWidth() - 28) / 16.0f);
            this.xSize = 23 + 16 * this.middleSegmentCount + 41;
            int newGuiLeft = (this.width - this.xSize) / 2;
            int dist = newGuiLeft - this.guiLeft;
            this.guiLeft = newGuiLeft;
            this.rowList.setXPos(this.guiLeft + 10);
            this.renderables.forEach(elem -> {
                if (elem instanceof AbstractWidget) {
                    AbstractWidget widget = (AbstractWidget)elem;
                    widget.setX(widget.getX() + dist);
                }
            });
            this.addRenderableWidget((GuiEventListener)new GuiButtonIE(this.guiLeft + 6, this.guiTop + 162, 72, 18, (Component)Component.translatable((String)"gui.immersiveengineering.config.machine_interface.add"), ADD_BUTTON, btn -> {
                MachineInterfaceBlockEntity.MachineInterfaceConfig newConfig = new MachineInterfaceBlockEntity.MachineInterfaceConfig(0, 0, DyeColor.WHITE);
                int idx = this.configList.size();
                this.configList.add(newConfig);
                this.sendConfig(idx, newConfig);
                this.rowList.scrollTo(this.rowList.addRow(x$0 -> {
                    AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
                }).getRowIndex());
            }));
            this.addRenderableWidget((GuiEventListener)new GuiButtonDyeColor(this.guiLeft + this.xSize - 40, this.guiTop + 163, 16, 16, () -> ((MachineInterfaceBlockEntity)this.blockEntity).inputColor.getId(), COLOR_BUTTON, btn -> this.sendInputColor((DyeColor)btn.getNextState()), ItemBatcherScreen::gatherRedstoneTooltip));
            this.addRenderableWidget((GuiEventListener)new GuiButtonIE(this.guiLeft + this.xSize - 20, this.guiTop + 12, 16, 12, (Component)Component.empty(), UP, btn -> this.rowList.scrollUp()));
            this.addRenderableWidget((GuiEventListener)new GuiButtonIE(this.guiLeft + this.xSize - 20, this.guiTop + 147, 16, 12, (Component)Component.empty(), DOWN, btn -> this.rowList.scrollDown()));
        }
    }

    private MachineInterfaceBlockEntity.MachineInterfaceConfig<?> getConfigSafe(IntSupplier supp) {
        int i = supp.getAsInt();
        if (this.configList == null || i >= this.configList.size()) {
            return FALLBACK_CONFIG;
        }
        return this.configList.get(i);
    }

    private void removeConfigurationRow(int idx) {
        for (AbstractWidget widget : this.rowList.removeRow(idx)) {
            this.removeWidget((GuiEventListener)widget);
        }
        this.configList.remove(idx);
        this.sendConfig(idx, null);
    }

    private void sendConfig(int idx, @Nullable MachineInterfaceBlockEntity.MachineInterfaceConfig<?> config) {
        if (config != null) {
            this.configList.set(idx, config);
        }
        CompoundTag message = new CompoundTag();
        message.putInt("idx", idx);
        if (config != null) {
            message.put("configuration", (Tag)config.writeToNBT());
        } else {
            message.putBoolean("delete", true);
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new MessageBlockEntitySync(this.blockEntity, message), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void sendInputColor(DyeColor col) {
        ((MachineInterfaceBlockEntity)this.blockEntity).inputColor = col;
        CompoundTag message = new CompoundTag();
        message.putInt("inputColor", col.getId());
        PacketDistributor.sendToServer((CustomPacketPayload)new MessageBlockEntitySync(this.blockEntity, message), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.availableChecks == null) {
            graphics.blit(TEXTURE, this.guiLeft, this.guiTop + (this.ySize - 74) / 2, 112, 80, this.xSize, 106);
        } else {
            graphics.blit(TEXTURE, this.guiLeft, this.guiTop, 0, 0, 23, this.ySize);
            int offset = 23;
            int i = 0;
            while (i < this.middleSegmentCount) {
                graphics.blit(TEXTURE, this.guiLeft + offset, this.guiTop, 25, 0, 16, this.ySize);
                ++i;
                offset += 16;
            }
            graphics.blit(TEXTURE, this.guiLeft + offset, this.guiTop, 43, 0, 41, this.ySize);
        }
    }

    @Override
    protected void drawGuiContainerForegroundLayer(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.availableChecks == null) {
            MutableComponent c = Component.translatable((String)"gui.immersiveengineering.config.machine_interface.not_connected");
            List text = this.font.split((FormattedText)c, 122);
            int yPos = this.guiTop + (this.ySize - 74) / 2 + 14;
            for (int i = 0; i < text.size(); ++i) {
                FormattedCharSequence formattedCharSequence = (FormattedCharSequence)text.get(i);
                Objects.requireNonNull(this.font);
                graphics.drawString(this.font, formattedCharSequence, this.guiLeft + 12, yPos + i * 9, 0x555555, false);
            }
        } else {
            MutableComponent text = Component.translatable((String)"gui.immersiveengineering.config.machine_interface.input_color");
            int textWidth = this.font.width((FormattedText)text);
            graphics.drawString(this.font, (Component)text, this.guiLeft + this.xSize - 48 - textWidth, this.guiTop + 167, 0xE0E0E0, false);
        }
        ArrayList<Component> tooltip = new ArrayList<Component>();
        for (GuiEventListener w : this.children()) {
            if (!w.isMouseOver((double)mouseX, (double)mouseY) || !(w instanceof ITooltipWidget)) continue;
            ITooltipWidget ttw = (ITooltipWidget)w;
            ttw.gatherTooltip(mouseX, mouseY, tooltip);
        }
        if (!tooltip.isEmpty()) {
            graphics.renderTooltip(this.font, tooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    private static class GuiButtonDelete
    extends GuiButtonIE
    implements ITooltipWidget {
        public GuiButtonDelete(int x, int y, GuiButtonIE.IIEPressable<?> handler) {
            super(x, y, 16, 16, (Component)Component.empty(), DELETE, handler);
        }

        @Override
        public void gatherTooltip(int mouseX, int mouseY, List<Component> tooltip) {
            tooltip.add((Component)Component.translatable((String)"gui.immersiveengineering.config.machine_interface.remove"));
        }
    }
}

