/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.config.IEClientConfig;
import blusunrize.immersiveengineering.common.items.EarmuffsItem;
import blusunrize.immersiveengineering.common.register.IEDataComponents;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;

@EventBusSubscriber(value={Dist.CLIENT}, modid="immersiveengineering", bus=EventBusSubscriber.Bus.GAME)
public class EarmuffHandler {
    private static final Map<SoundSource, Float> LAST_MULTIPLIERS = EarmuffHandler.makeDefaultMultipliers();
    private static Set<ResourceLocation> IGNORED_SOUNDS = Set.of();

    @SubscribeEvent
    public static void updateEarmuffMultipliers(ClientTickEvent.Pre ev) {
        if (ClientUtils.mc().player == null) {
            return;
        }
        Map<SoundSource, Float> newMultipliers = EarmuffHandler.makeDefaultMultipliers();
        ItemStack earmuffs = EarmuffsItem.EARMUFF_GETTERS.getFrom((LivingEntity)ClientUtils.mc().player);
        if (!earmuffs.isEmpty()) {
            EarmuffsItem.EarmuffData earmuffConfig = (EarmuffsItem.EarmuffData)earmuffs.getOrDefault(IEDataComponents.EARMUFF_DATA, (Object)EarmuffsItem.EarmuffData.DEFAULT);
            SoundSource[] soundSourceArray = SoundSource.values();
            int n = soundSourceArray.length;
            for (int i = 0; i < n; ++i) {
                SoundSource source = soundSourceArray[i];
                if (!EarmuffsItem.affectedSoundCategories.contains(source.getName()) || !earmuffConfig.affectedCategories().contains(source.getName())) continue;
                float newMultiplier = Math.max(0.05f, earmuffConfig.volumeMod());
                newMultipliers.put(source, Float.valueOf(newMultiplier));
            }
        }
        for (SoundSource source : SoundSource.values()) {
            if (LAST_MULTIPLIERS.get(source).floatValue() == newMultipliers.get(source).floatValue()) continue;
            LAST_MULTIPLIERS.put(source, newMultipliers.get(source));
            Minecraft.getInstance().getSoundManager().updateSourceVolume(source, Minecraft.getInstance().options.getSoundSourceVolume(source));
        }
    }

    public static float getVolumeMultiplier(SoundInstance sound) {
        if (IGNORED_SOUNDS.contains(sound.getLocation())) {
            return 1.0f;
        }
        return LAST_MULTIPLIERS.get(sound.getSource()).floatValue();
    }

    public static void onConfigUpdate() {
        IGNORED_SOUNDS = ((List)IEClientConfig.earDefenders_SoundBlacklist.get()).stream().map(ResourceLocation::tryParse).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private static Map<SoundSource, Float> makeDefaultMultipliers() {
        EnumMap<SoundSource, Float> result = new EnumMap<SoundSource, Float>(SoundSource.class);
        for (SoundSource type : SoundSource.values()) {
            result.put(type, Float.valueOf(1.0f));
        }
        return result;
    }
}

