/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires.redstone;

import blusunrize.immersiveengineering.api.utils.SafeChunkUtils;
import blusunrize.immersiveengineering.api.wires.redstone.RedstoneNetworkHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;

public class WirelessRedstoneHandler {
    private static final Map<ServerLevel, WirelessRedstoneHandler> LEVEL_CACHE = new ConcurrentHashMap<ServerLevel, WirelessRedstoneHandler>();
    private final ServerLevel level;
    private final Map<BlockPos, IWirelessRedstoneComponent> registeredComponents = new HashMap<BlockPos, IWirelessRedstoneComponent>();

    public static WirelessRedstoneHandler getHandler(ServerLevel level) {
        return LEVEL_CACHE.computeIfAbsent(level, WirelessRedstoneHandler::new);
    }

    public WirelessRedstoneHandler(ServerLevel level) {
        this.level = level;
    }

    public void register(BlockPos pos, IWirelessRedstoneComponent component) {
        this.registeredComponents.put(pos, component);
    }

    public void unregister(BlockPos pos) {
        this.registeredComponents.remove(pos);
    }

    public boolean isRegistered(BlockPos pos, IWirelessRedstoneComponent fromComponent) {
        return this.registeredComponents.containsKey(pos) && this.registeredComponents.get(pos) == fromComponent;
    }

    public byte[] fetchSignals(BlockPos fromPos, IWirelessRedstoneComponent fromComponent) {
        return this.registeredComponents.entrySet().stream().filter(target -> SafeChunkUtils.isChunkSafe((LevelAccessor)this.level, (BlockPos)target.getKey())).filter(target -> ((IWirelessRedstoneComponent)target.getValue()).getFrequency() == fromComponent.getFrequency()).filter(target -> ((IWirelessRedstoneComponent)target.getValue()).isActive()).filter(target -> !fromPos.equals(target.getKey())).filter(target -> {
            double chunkDist = fromPos.distSqr((Vec3i)target.getKey()) / 256.0;
            return chunkDist < (double)((IWirelessRedstoneComponent)target.getValue()).getChunkRangeSq() && chunkDist < (double)fromComponent.getChunkRangeSq();
        }).map(component -> ((IWirelessRedstoneComponent)component.getValue()).getBroadcastSignal()).reduce(new byte[16], (bytes1, bytes2) -> {
            byte[] out = new byte[16];
            RedstoneNetworkHandler.fillWithMax(bytes2, bytes1, out);
            return out;
        });
    }

    public void notifyComponents(BlockPos fromPos, IWirelessRedstoneComponent fromComponent) {
        this.registeredComponents.entrySet().stream().filter(target -> SafeChunkUtils.isChunkSafe((LevelAccessor)this.level, (BlockPos)target.getKey())).filter(target -> ((IWirelessRedstoneComponent)target.getValue()).getFrequency() == fromComponent.getFrequency()).filter(target -> ((IWirelessRedstoneComponent)target.getValue()).isActive()).filter(target -> !fromPos.equals(target.getKey())).filter(target -> {
            double chunkDist = fromPos.distSqr((Vec3i)target.getKey()) / 256.0;
            return chunkDist < (double)((IWirelessRedstoneComponent)target.getValue()).getChunkRangeSq() && chunkDist < (double)fromComponent.getChunkRangeSq();
        }).forEach(target -> ((IWirelessRedstoneComponent)target.getValue()).notifyOfUpdate(this));
    }

    public List<Vec3> getRelativeComponentsInRange(BlockPos fromPos, IWirelessRedstoneComponent fromComponent) {
        Vec3 fromVec = Vec3.atCenterOf((Vec3i)fromPos);
        return this.registeredComponents.entrySet().stream().filter(target -> ((IWirelessRedstoneComponent)target.getValue()).getFrequency() == fromComponent.getFrequency()).filter(target -> ((IWirelessRedstoneComponent)target.getValue()).isActive()).filter(target -> !fromPos.equals(target.getKey())).filter(target -> {
            double chunkDist = fromPos.distSqr((Vec3i)target.getKey()) / 256.0;
            return chunkDist < (double)((IWirelessRedstoneComponent)target.getValue()).getChunkRangeSq() && chunkDist < (double)fromComponent.getChunkRangeSq();
        }).map(Map.Entry::getKey).map(blockPos -> Vec3.atCenterOf((Vec3i)blockPos).subtract(fromVec)).toList();
    }

    public static interface IWirelessRedstoneComponent {
        public boolean isActive();

        public int getChunkRangeSq();

        public int getFrequency();

        public byte[] getBroadcastSignal();

        public void notifyOfUpdate(WirelessRedstoneHandler var1);
    }
}

