/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.utils;

import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class IngredientUtils {
    public static boolean stacksMatchIngredientList(List<Ingredient> list, NonNullList<ItemStack> stacks) {
        return IngredientUtils.stacksMatchList(list, stacks, i -> 1, Ingredient::test);
    }

    public static boolean stacksMatchIngredientWithSizeList(List<IngredientWithSize> list, NonNullList<ItemStack> stacks) {
        return IngredientUtils.stacksMatchList(list, stacks, IngredientWithSize::getCount, IngredientWithSize::testIgnoringSize);
    }

    public static Ingredient createIngredientFromList(List<ItemStack> list) {
        return Ingredient.of((ItemStack[])list.toArray(new ItemStack[0]));
    }

    private static <T> boolean stacksMatchList(List<T> list, NonNullList<ItemStack> stacks, Function<T, Integer> size, BiPredicate<T, ItemStack> matchesIgnoringSize) {
        ArrayList<ItemStack> queryList = new ArrayList<ItemStack>(stacks.size());
        for (ItemStack s : stacks) {
            if (s.isEmpty()) continue;
            queryList.add(s.copy());
        }
        for (T ingr : list) {
            if (ingr == null) continue;
            int amount = size.apply(ingr);
            Iterator it = queryList.iterator();
            while (it.hasNext()) {
                ItemStack query = (ItemStack)it.next();
                if (query.isEmpty()) continue;
                if (matchesIgnoringSize.test(ingr, query)) {
                    if (query.getCount() > amount) {
                        query.shrink(amount);
                        amount = 0;
                    } else {
                        amount -= query.getCount();
                        query.setCount(0);
                    }
                }
                if (query.getCount() <= 0) {
                    it.remove();
                }
                if (amount > 0) continue;
                break;
            }
            if (amount <= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean hasPlayerIngredient(Player player, IngredientWithSize ingredient) {
        ItemStack itemstack;
        int amount = ingredient.getCount();
        for (InteractionHand hand : InteractionHand.values()) {
            itemstack = player.getItemInHand(hand);
            if (!ingredient.test(itemstack) || (amount -= itemstack.getCount()) > 0) continue;
            return true;
        }
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            itemstack = player.getInventory().getItem(i);
            if (!ingredient.test(itemstack) || (amount -= itemstack.getCount()) > 0) continue;
            return true;
        }
        return amount <= 0;
    }

    public static void consumePlayerIngredient(Player player, IngredientWithSize ingredient) {
        ItemStack itemstack;
        int amount = ingredient.getCount();
        for (InteractionHand hand : InteractionHand.values()) {
            itemstack = player.getItemInHand(hand);
            if (!ingredient.testIgnoringSize(itemstack)) continue;
            int taken = Math.min(amount, itemstack.getCount());
            amount -= taken;
            itemstack.shrink(taken);
            if (itemstack.getCount() <= 0) {
                player.setItemInHand(hand, ItemStack.EMPTY);
            }
            if (amount > 0) continue;
            return;
        }
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            itemstack = player.getInventory().getItem(i);
            if (!ingredient.testIgnoringSize(itemstack)) continue;
            int taken = Math.min(amount, itemstack.getCount());
            amount -= taken;
            itemstack.shrink(taken);
            if (itemstack.getCount() <= 0) {
                player.getInventory().setItem(i, ItemStack.EMPTY);
            }
            if (amount > 0) continue;
            return;
        }
    }
}

