/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IERecipeTypes;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.api.crafting.TagOutputList;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import blusunrize.immersiveengineering.api.utils.SetRestrictedField;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.registries.DeferredHolder;

public class SawmillRecipe
extends MultiblockRecipe {
    public static DeferredHolder<RecipeSerializer<?>, IERecipeSerializer<SawmillRecipe>> SERIALIZER;
    public static final CachedRecipeList<SawmillRecipe> RECIPES;
    public static final SetRestrictedField<MultiblockRecipe.RecipeMultiplier> MULTIPLIERS;
    public final Ingredient input;
    public final TagOutput stripped;
    public final TagOutputList secondaryStripping;
    public final TagOutput output;
    public final TagOutputList secondaryOutputs;

    public SawmillRecipe(TagOutput output, TagOutput stripped, Ingredient input, int energy, TagOutputList secondaryStripping, TagOutputList secondaryOutputs) {
        super(output, IERecipeTypes.SAWMILL, 80, energy, MULTIPLIERS);
        this.output = output;
        this.stripped = stripped;
        this.input = input;
        this.secondaryOutputs = secondaryOutputs;
        this.secondaryStripping = secondaryStripping;
        this.setInputList(Lists.newArrayList((Object[])new Ingredient[]{this.input}));
        this.outputList = new TagOutputList(List.of(output));
    }

    protected IERecipeSerializer<SawmillRecipe> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    @Override
    public NonNullList<ItemStack> getActualItemOutputs() {
        NonNullList list = NonNullList.create();
        list.add((Object)this.stripped.get());
        for (ItemStack output : this.secondaryStripping.get()) {
            if (output.isEmpty()) continue;
            list.add((Object)output);
        }
        list.add((Object)this.output.get());
        for (ItemStack output : this.secondaryOutputs.get()) {
            if (output.isEmpty()) continue;
            list.add((Object)output);
        }
        return list;
    }

    public static SawmillRecipe findRecipe(Level level, ItemStack input) {
        if (!input.isEmpty()) {
            for (RecipeHolder<SawmillRecipe> recipe : RECIPES.getRecipes(level)) {
                if (!((SawmillRecipe)recipe.value()).input.test(input)) continue;
                return (SawmillRecipe)recipe.value();
            }
        }
        return null;
    }

    @Override
    public int getMultipleProcessTicks() {
        return 0;
    }

    static {
        RECIPES = new CachedRecipeList<SawmillRecipe>(IERecipeTypes.SAWMILL);
        MULTIPLIERS = SetRestrictedField.common();
    }
}

