/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IERecipeTypes;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.api.crafting.TagOutputList;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import blusunrize.immersiveengineering.api.utils.SetRestrictedField;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.registries.DeferredHolder;

public class CrusherRecipe
extends MultiblockRecipe {
    public static DeferredHolder<RecipeSerializer<?>, IERecipeSerializer<CrusherRecipe>> SERIALIZER;
    public static final CachedRecipeList<CrusherRecipe> RECIPES;
    public static final SetRestrictedField<MultiblockRecipe.RecipeMultiplier> MULTIPLIERS;
    public final Ingredient input;
    public final TagOutput output;
    public final List<StackWithChance> secondaryOutputs;

    public CrusherRecipe(TagOutput output, Ingredient input, int energy, List<StackWithChance> secondaryOutputs) {
        super(output, IERecipeTypes.CRUSHER, 50, energy, MULTIPLIERS);
        this.output = output;
        this.input = input;
        this.secondaryOutputs = secondaryOutputs;
        this.setInputList(Lists.newArrayList((Object[])new Ingredient[]{this.input}));
        this.outputList = new TagOutputList(this.output);
    }

    protected IERecipeSerializer<CrusherRecipe> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    @Override
    public NonNullList<ItemStack> getActualItemOutputs() {
        NonNullList list = NonNullList.create();
        list.add((Object)this.output.get());
        for (StackWithChance output : this.secondaryOutputs) {
            ItemStack realStack = output.stack().get();
            if (realStack.isEmpty() || !(ApiUtils.RANDOM.nextFloat() < output.chance())) continue;
            list.add((Object)realStack);
        }
        return list;
    }

    public static RecipeHolder<CrusherRecipe> findRecipe(Level level, ItemStack input) {
        for (RecipeHolder<CrusherRecipe> recipe : RECIPES.getRecipes(level)) {
            if (!((CrusherRecipe)recipe.value()).input.test(input)) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public int getMultipleProcessTicks() {
        return 4;
    }

    static {
        RECIPES = new CachedRecipeList<CrusherRecipe>(IERecipeTypes.CRUSHER);
        MULTIPLIERS = SetRestrictedField.common();
    }
}

