/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api;

import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class ComparableItemStack {
    public ItemStack stack;
    public boolean compareComponents;

    public ComparableItemStack(ItemStack stack) {
        this(stack, false);
    }

    public ComparableItemStack(ItemStack stack, boolean copy) {
        if (stack == null) {
            throw new RuntimeException("You cannot instantiate a ComparableItemStack with null for an Item!");
        }
        this.stack = stack;
        if (copy) {
            this.copy();
        }
    }

    public static ComparableItemStack create(ItemStack stack, boolean copy) {
        return ComparableItemStack.create(stack, copy, !stack.getComponents().isEmpty());
    }

    public static ComparableItemStack create(ItemStack stack, boolean copy, boolean useNbt) {
        ComparableItemStack comp = new ComparableItemStack(stack, copy);
        comp.setCompareComponents(useNbt);
        return comp;
    }

    public void copy() {
        this.stack = this.stack.copy();
    }

    public ComparableItemStack setCompareComponents(boolean compareComponents) {
        this.compareComponents = compareComponents;
        return this;
    }

    public String toString() {
        return "ComparableStack: {" + this.stack.toString() + "}; checkNBT: " + this.compareComponents;
    }

    public int hashCode() {
        return ItemStack.hashItemAndComponents((ItemStack)this.stack);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ComparableItemStack)) {
            return false;
        }
        ItemStack otherStack = ((ComparableItemStack)object).stack;
        if (!ItemStack.isSameItem((ItemStack)this.stack, (ItemStack)otherStack)) {
            return false;
        }
        if (this.compareComponents) {
            return Objects.equals(this.stack.getComponents(), otherStack.getComponents());
        }
        return true;
    }

    public CompoundTag writeToNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        nbt.put("stack", this.stack.save(provider));
        nbt.putBoolean("useNBT", this.compareComponents);
        return nbt;
    }

    public static ComparableItemStack readFromNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        ComparableItemStack comp = new ComparableItemStack((ItemStack)ItemStack.parse((HolderLookup.Provider)provider, (Tag)nbt.getCompound("stack")).orElseThrow(), false);
        comp.compareComponents = nbt.getBoolean("useNBT");
        return comp;
    }
}

