/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.immeng;

import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.IManagedGridNode;
import appeng.api.util.AECableType;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.generic.ImmersiveConnectableBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.EnergyConnectorBlockEntity;
import dev.technici4n.immeng.ImmEng;
import dev.technici4n.immeng.MELocalHandler;
import dev.technici4n.immeng.MEWireType;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MEConnectorBlockEntity
extends ImmersiveConnectableBlockEntity
implements IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IBlockBounds,
IInWorldGridNodeHost {
    private final boolean relay;
    final IManagedGridNode gridNode = GridHelper.createManagedNode((Object)((Object)this), (nodeOwner, node) -> this.setChanged()).setFlags(new GridFlags[]{GridFlags.DENSE_CAPACITY}).setIdlePowerUsage(0.0);
    final Map<ConnectionPoint, IManagedGridNode> wireGridNodes = new LinkedHashMap<ConnectionPoint, IManagedGridNode>();

    IManagedGridNode createWireNode() {
        return GridHelper.createManagedNode((Object)((Object)this), (nodeOwner, node) -> this.setChanged()).setIdlePowerUsage(0.0);
    }

    public MEConnectorBlockEntity(BlockPos pos, BlockState state) {
        super(state.is(ImmEng.ME_RELAY) ? (BlockEntityType)ImmEng.ME_RELAY_BE.get() : (BlockEntityType)ImmEng.ME_CONNECTOR_BE.get(), pos, state);
        this.relay = state.is(ImmEng.ME_RELAY);
        if (this.relay) {
            this.gridNode.setVisualRepresentation(ImmEng.ME_RELAY_ITEM);
        } else {
            this.gridNode.setVisualRepresentation(ImmEng.ME_CONNECTOR_ITEM);
            this.gridNode.setInWorldNode(true);
        }
        this.setBlockState(state);
    }

    public boolean canConnectCable(WireType wireType, ConnectionPoint connectionPoint, Vec3i vec3i) {
        if (this.relay) {
            return true;
        }
        LocalWireNetwork local = this.globalNet.getNullableLocalNet(new ConnectionPoint(this.worldPosition, 0));
        return local == null || local.getConnections(this.worldPosition).isEmpty();
    }

    public Vec3 getConnectionOffset(ConnectionPoint connectionPoint, ConnectionPoint connectionPoint1, WireType wireType) {
        Direction side = this.getFacing().getOpposite();
        double conRadius = wireType.getRenderDiameter() / 2.0;
        if (!this.relay) {
            conRadius += 0.25;
        }
        return new Vec3(0.5 - conRadius * (double)side.getStepX(), 0.5 - conRadius * (double)side.getStepY(), 0.5 - conRadius * (double)side.getStepZ());
    }

    @NotNull
    public VoxelShape getBlockBounds(@Nullable CollisionContext collisionContext) {
        if (this.relay) {
            return EnergyConnectorBlockEntity.getConnectorBounds((Direction)this.getFacing(), (float)0.5f);
        }
        return EnergyConnectorBlockEntity.getConnectorBounds((Direction)this.getFacing(), (float)0.25f);
    }

    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_ALL;
    }

    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.SIDE_CLICKED;
    }

    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return true;
    }

    public void loadAdditional(CompoundTag nbtIn, HolderLookup.Provider registries) {
        super.loadAdditional(nbtIn, registries);
        this.gridNode.loadFromNBT(nbtIn);
        ListTag wireNodes = nbtIn.getList("wirenodes", 10);
        for (int i = 0; i < wireNodes.size(); ++i) {
            CompoundTag entry = wireNodes.getCompound(i);
            ConnectionPoint cp = new ConnectionPoint(entry);
            IManagedGridNode node = this.createWireNode();
            node.loadFromNBT(entry);
            this.wireGridNodes.put(cp, node);
        }
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        this.gridNode.saveToNBT(nbt);
        ListTag wireNodes = new ListTag();
        for (Map.Entry<ConnectionPoint, IManagedGridNode> entry : this.wireGridNodes.entrySet()) {
            CompoundTag tag = entry.getKey().createTag();
            entry.getValue().saveToNBT(tag);
            wireNodes.add((Object)tag);
        }
        nbt.put("wirenodes", (Tag)wireNodes);
    }

    private ConnectionPoint getConnectionPoint() {
        return new ConnectionPoint(this.worldPosition, 0);
    }

    void loadConnectionOnA(Connection connection, LocalWireNetwork localNet) {
        if (!Objects.equals(connection.getEndA(), this.getConnectionPoint())) {
            throw new IllegalArgumentException("Cannot call loadConnection on B end.");
        }
        ConnectionPoint point = connection.getEndB();
        IManagedGridNode wireNode = this.wireGridNodes.get(point);
        if (wireNode == null) {
            wireNode = this.createWireNode();
            this.wireGridNodes.put(point, wireNode);
        } else if (wireNode.isReady()) {
            return;
        }
        if (connection.type == MEWireType.DENSE) {
            wireNode.setFlags(new GridFlags[]{GridFlags.DENSE_CAPACITY});
            wireNode.setVisualRepresentation(ImmEng.ME_WIRE_DENSE_COIL);
        } else {
            wireNode.setFlags(new GridFlags[]{GridFlags.PREFERRED});
            wireNode.setVisualRepresentation(ImmEng.ME_WIRE_COIL);
        }
        wireNode.create(this.getLevelNonnull(), null);
        GridHelper.createConnection((IGridNode)this.gridNode.getNode(), (IGridNode)wireNode.getNode());
        IImmersiveConnectable iImmersiveConnectable = localNet.getConnector(connection.getEndB());
        if (iImmersiveConnectable instanceof MEConnectorBlockEntity) {
            MEConnectorBlockEntity connectorB = (MEConnectorBlockEntity)iImmersiveConnectable;
            IGridNode otherNode = connectorB.gridNode.getNode();
            if (otherNode != null) {
                GridHelper.createConnection((IGridNode)wireNode.getNode(), (IGridNode)otherNode);
            }
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.level.isClientSide()) {
            return;
        }
        this.gridNode.create(this.level, this.worldPosition);
        ConnectionPoint connectionPoint = this.getConnectionPoint();
        LocalWireNetwork localNet = GlobalWireNetwork.getNetwork((Level)this.level).getLocalNet(this.worldPosition);
        Collection connections = localNet.getConnections(connectionPoint);
        HashSet<ConnectionPoint> connectedPoints = new HashSet<ConnectionPoint>();
        for (Connection connection : connections) {
            if (!connection.getEndA().equals((Object)connectionPoint)) continue;
            this.loadConnectionOnA(connection, localNet);
            ConnectionPoint point = connection.getEndB();
            connectedPoints.add(point);
        }
        this.wireGridNodes.keySet().removeIf(key -> !connectedPoints.contains(key));
        for (Connection connection : connections) {
            IImmersiveConnectable iImmersiveConnectable;
            if (!connection.getEndB().equals((Object)connectionPoint) || !((iImmersiveConnectable = localNet.getConnector(connection.getEndA())) instanceof MEConnectorBlockEntity)) continue;
            MEConnectorBlockEntity connectorA = (MEConnectorBlockEntity)iImmersiveConnectable;
            IManagedGridNode wireNode = connectorA.wireGridNodes.get(connection.getEndB());
            if (wireNode == null || !wireNode.isReady()) continue;
            GridHelper.createConnection((IGridNode)wireNode.getNode(), (IGridNode)this.gridNode.getNode());
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.gridNode.destroy();
        this.wireGridNodes.values().forEach(IManagedGridNode::destroy);
    }

    public void setRemovedIE() {
        super.setRemovedIE();
        this.gridNode.destroy();
        this.wireGridNodes.values().forEach(IManagedGridNode::destroy);
    }

    @Nullable
    public IGridNode getGridNode(Direction dir) {
        return !this.relay && dir == this.getFacing() ? this.gridNode.getNode() : null;
    }

    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.DENSE_SMART;
    }

    public void setBlockState(BlockState newState) {
        super.setBlockState(newState);
        if (!(this.level != null && this.level.isClientSide() || this.relay)) {
            this.gridNode.setExposedOnSides(Set.of(this.getFacing()));
        }
    }

    public Collection<ResourceLocation> getRequestedHandlers() {
        return List.of(MELocalHandler.ID);
    }
}

