/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.world.item;

import fuzs.illagerinvasion.init.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.FireChargeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.gameevent.GameEvent;

public class MagicalFireChargeItem
extends FireChargeItem {
    public MagicalFireChargeItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos blockPos = context.getClickedPos();
        boolean bl = false;
        blockPos = blockPos.relative(context.getClickedFace());
        if (((Block)ModRegistry.MAGIC_FIRE_BLOCK.value()).defaultBlockState().canSurvive((LevelReader)level, blockPos) && BaseFireBlock.canBePlacedAt((Level)level, (BlockPos)blockPos, (Direction)context.getHorizontalDirection())) {
            this.playSound(level, blockPos);
            level.setBlockAndUpdate(blockPos, ((Block)ModRegistry.MAGIC_FIRE_BLOCK.value()).defaultBlockState());
            level.gameEvent((Entity)context.getPlayer(), (Holder)GameEvent.BLOCK_PLACE, blockPos);
            bl = true;
        }
        if (bl) {
            context.getItemInHand().shrink(1);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.FAIL;
    }

    private void playSound(Level level, BlockPos pos) {
        RandomSource randomSource = level.getRandom();
        level.playSound(null, pos, SoundEvents.FIRECHARGE_USE, SoundSource.BLOCKS, 1.0f, (randomSource.nextFloat() - randomSource.nextFloat()) * 0.2f + 1.0f);
    }
}

