/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.world.entity.monster;

import fuzs.illagerinvasion.init.ModRegistry;
import fuzs.illagerinvasion.init.ModSoundEvents;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class Provoker
extends SpellcasterIllager
implements RangedAttackMob {
    private int buffAllyCooldown;

    public Provoker(EntityType<? extends Provoker> entityType, Level world) {
        super(entityType, world);
        this.xpReward = 10;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new LookAtTargetOrWololoTarget());
        this.goalSelector.addGoal(3, (Goal)new BuffAllyGoal());
        this.goalSelector.addGoal(4, (Goal)new RangedBowAttackGoal((Monster)this, 0.5, 20, 15.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.BOW));
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    public void performRangedAttack(LivingEntity target, float pullProgress) {
        ItemStack itemInHand = this.getItemInHand(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, (Item)Items.BOW));
        ItemStack itemStack = this.getProjectile(itemInHand);
        AbstractArrow persistentProjectileEntity = ProjectileUtil.getMobArrow((LivingEntity)this, (ItemStack)itemStack, (float)pullProgress, (ItemStack)itemInHand);
        double d = target.getX() - this.getX();
        double e = target.getY(0.3333333333333333) - persistentProjectileEntity.getY();
        double f = target.getZ() - this.getZ();
        double g = Math.sqrt(d * d + f * f);
        persistentProjectileEntity.shoot(d, e + g * (double)0.2f, f, 1.6f, (float)(14 - this.level().getDifficulty().getId() * 4));
        this.playSound(SoundEvents.SKELETON_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        this.level().addFreshEntity((Entity)persistentProjectileEntity);
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader level) {
        return 0.0f;
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    public SoundEvent getCelebrateSound() {
        return (SoundEvent)ModSoundEvents.PROVOKER_CELEBRATE_SOUND_EVENT.value();
    }

    protected void customServerAiStep() {
        --this.buffAllyCooldown;
        super.customServerAiStep();
    }

    public boolean isAlliedTo(Entity other) {
        LivingEntity livingEntity;
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (super.isAlliedTo(other)) {
            return true;
        }
        if (other instanceof Vex) {
            return this.isAlliedTo((Entity)((Vex)other).getOwner());
        }
        if (other instanceof LivingEntity && (livingEntity = (LivingEntity)other).getType().is(EntityTypeTags.ILLAGER_FRIENDS)) {
            return this.getTeam() == null && other.getTeam() == null;
        }
        return false;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ModSoundEvents.PROVOKER_AMBIENT_SOUND_EVENT.value();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSoundEvents.PROVOKER_DEATH_SOUND_EVENT.value();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)ModSoundEvents.PROVOKER_HURT_SOUND_EVENT.value();
    }

    protected SoundEvent getCastingSoundEvent() {
        return SoundEvents.EVOKER_CAST_SPELL;
    }

    public void applyRaidBuffs(ServerLevel level, int wave, boolean unused) {
    }

    public AbstractIllager.IllagerArmPose getArmPose() {
        if (this.isCastingSpell()) {
            return AbstractIllager.IllagerArmPose.SPELLCASTING;
        }
        if (this.isAggressive()) {
            return AbstractIllager.IllagerArmPose.BOW_AND_ARROW;
        }
        return AbstractIllager.IllagerArmPose.CROSSED;
    }

    class LookAtTargetOrWololoTarget
    extends SpellcasterIllager.SpellcasterCastingSpellGoal {
        LookAtTargetOrWololoTarget() {
            super((SpellcasterIllager)Provoker.this);
        }

        public void tick() {
            if (Provoker.this.getTarget() != null) {
                Provoker.this.getLookControl().setLookAt((Entity)Provoker.this.getTarget(), (float)Provoker.this.getMaxHeadYRot(), (float)Provoker.this.getMaxHeadXRot());
            }
        }
    }

    public class BuffAllyGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        public BuffAllyGoal() {
            super((SpellcasterIllager)Provoker.this);
        }

        public boolean canUse() {
            if (Provoker.this.getTarget() == null) {
                return false;
            }
            return Provoker.this.buffAllyCooldown < 0;
        }

        private List<LivingEntity> getTargets() {
            return Provoker.this.level().getEntitiesOfClass(LivingEntity.class, Provoker.this.getBoundingBox().inflate(12.0), entity -> entity instanceof AbstractIllager);
        }

        public void stop() {
            super.stop();
        }

        private void buff(LivingEntity entity) {
            entity.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 120, 0));
            entity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 120, 0));
            double x = entity.getX();
            double y = entity.getY() + 1.0;
            double z = entity.getZ();
            ((ServerLevel)Provoker.this.level()).sendParticles((ParticleOptions)ParticleTypes.ANGRY_VILLAGER, x, y, z, 10, 0.4, 0.4, 0.4, 0.15);
        }

        protected void performSpellCasting() {
            Provoker.this.buffAllyCooldown = 300;
            this.getTargets().forEach(this::buff);
        }

        protected int getCastWarmupTime() {
            return 40;
        }

        protected int getCastingTime() {
            return 60;
        }

        protected int getCastingInterval() {
            return 140;
        }

        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.ILLUSIONER_PREPARE_BLINDNESS;
        }

        protected SpellcasterIllager.IllagerSpell getSpell() {
            return ModRegistry.PROVOKE_ILLAGER_SPELL;
        }
    }
}

