/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.hyrule_terrors.registry;

import dev.architectury.registry.level.biome.BiomeModifications;
import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.level.entity.SpawnPlacementsRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import net.bandit.hyrule_terrors.HyruleTerrorsMod;
import net.bandit.hyrule_terrors.entity.mobs.Bokoblin;
import net.bandit.hyrule_terrors.entity.mobs.Chuchu;
import net.bandit.hyrule_terrors.entity.mobs.Keese;
import net.bandit.hyrule_terrors.entity.mobs.Lizalfos;
import net.bandit.hyrule_terrors.registry.TagRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.Heightmap;

public class EntityRegistry {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((String)"hyrule_terrors", (ResourceKey)Registries.ENTITY_TYPE);
    public static final RegistrySupplier<EntityType<Lizalfos>> LIZALFOS = ENTITIES.register("lizalfos", () -> EntityType.Builder.of(Lizalfos::new, (MobCategory)MobCategory.MONSTER).sized(1.5f, 2.0f).build(HyruleTerrorsMod.modResource("lizalfos").toString()));
    public static final RegistrySupplier<EntityType<Chuchu>> CHUCHU = ENTITIES.register("chuchu", () -> EntityType.Builder.of(Chuchu::new, (MobCategory)MobCategory.MONSTER).sized(0.6f, 0.75f).build(HyruleTerrorsMod.modResource("chuchu").toString()));
    public static final RegistrySupplier<EntityType<Keese>> KEESE = ENTITIES.register("keese", () -> EntityType.Builder.of(Keese::new, (MobCategory)MobCategory.MONSTER).sized(0.55f, 0.75f).build(HyruleTerrorsMod.modResource("keese").toString()));
    public static final RegistrySupplier<EntityType<Bokoblin>> BOKOBLIN = ENTITIES.register("bokoblin", () -> EntityType.Builder.of(Bokoblin::new, (MobCategory)MobCategory.MONSTER).sized(0.75f, 1.75f).build(HyruleTerrorsMod.modResource("bokoblin").toString()));

    private static void initSpawns() {
        SpawnPlacementsRegistry.register(BOKOBLIN, (SpawnPlacementType)SpawnPlacementTypes.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules);
        BiomeModifications.addProperties(b -> b.hasTag(TagRegistry.BOKOBLIN_BIOMES), (ctx, b) -> b.getSpawnProperties().addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)BOKOBLIN.get(), HyruleTerrorsMod.config.bokoblinSpawnWeight, 1, 3)));
        SpawnPlacementsRegistry.register(CHUCHU, (SpawnPlacementType)SpawnPlacementTypes.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules);
        BiomeModifications.addProperties(b -> b.hasTag(TagRegistry.CHUCHU_BIOMES), (ctx, b) -> b.getSpawnProperties().addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)CHUCHU.get(), HyruleTerrorsMod.config.chuchuSpawnWeight, 2, 5)));
        SpawnPlacementsRegistry.register(LIZALFOS, (SpawnPlacementType)SpawnPlacementTypes.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules);
        BiomeModifications.addProperties(b -> b.hasTag(TagRegistry.LIZALFOS_BIOMES), (ctx, b) -> b.getSpawnProperties().addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)LIZALFOS.get(), HyruleTerrorsMod.config.lizalfosSpawnWeight, 1, 3)));
        SpawnPlacementsRegistry.register(KEESE, (SpawnPlacementType)SpawnPlacementTypes.NO_RESTRICTIONS, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules);
        BiomeModifications.addProperties(b -> b.hasTag(TagRegistry.KEESE_BIOMES), (ctx, b) -> b.getSpawnProperties().addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)KEESE.get(), HyruleTerrorsMod.config.keeseSpawnWeight, 2, 4)));
    }

    private static void initAttributes() {
        EntityAttributeRegistry.register(BOKOBLIN, Bokoblin::createAttributes);
        EntityAttributeRegistry.register(CHUCHU, Chuchu::createAttributes);
        EntityAttributeRegistry.register(LIZALFOS, Lizalfos::createAttributes);
        EntityAttributeRegistry.register(KEESE, Keese::createAttributes);
    }

    public static void init() {
        ENTITIES.register();
        EntityRegistry.initAttributes();
        EntityRegistry.initSpawns();
    }
}

