/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.hyrule_terrors.item.weapon.weapons;

import java.util.List;
import net.bandit.hyrule_terrors.item.armor.sets.ZoraArmorItem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class SilverLongsword
extends SwordItem {
    public SilverLongsword(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Level level = attacker.level();
        if (!level.isClientSide()) {
            level.playSound(null, attacker.blockPosition(), SoundEvents.TRIDENT_HIT, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        boolean isWet = attacker.isInWaterOrRain();
        boolean wearingFullZoraSet = false;
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            ItemStack head = player.getInventory().getArmor(3);
            ItemStack chest = player.getInventory().getArmor(2);
            ItemStack legs = player.getInventory().getArmor(1);
            ItemStack boots = player.getInventory().getArmor(0);
            boolean bl = wearingFullZoraSet = head.getItem() instanceof ZoraArmorItem && chest.getItem() instanceof ZoraArmorItem && legs.getItem() instanceof ZoraArmorItem && boots.getItem() instanceof ZoraArmorItem;
        }
        if (isWet && !level.isClientSide()) {
            float bonusDamage = 4.0f;
            if (wearingFullZoraSet) {
                bonusDamage += 2.0f;
            }
            target.hurt(level.damageSources().magic(), bonusDamage);
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repairWith) {
        return repairWith.is(Items.PRISMARINE_CRYSTALS) || repairWith.is(Items.PRISMARINE_SHARD) || super.isValidRepairItem(toRepair, repairWith);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"item.hyrule_terrors.silver_longsword.tooltip").withStyle(ChatFormatting.AQUA));
            tooltipComponents.add((Component)Component.translatable((String)"item.hyrule_terrors.silver_longsword.tooltip1").withStyle(ChatFormatting.GRAY));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"item.hyrule_terrors.hold_shift").withStyle(ChatFormatting.DARK_GRAY));
        }
    }
}

