/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.hyrule_terrors.item.weapon.weapons;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class BoulderBreaker
extends SwordItem {
    public BoulderBreaker(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Level level = attacker.level();
        if (!level.isClientSide()) {
            level.playSound(null, attacker.blockPosition(), SoundEvents.STONE_BREAK, SoundSource.PLAYERS, 1.0f, 0.75f);
        }
        if (target.getArmorCoverPercentage() > 0.25f && attacker instanceof Player) {
            Player player = (Player)attacker;
            target.hurt(level.damageSources().playerAttack(player), 3.0f);
        }
        target.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 40, 1, false, false));
        if (level.isClientSide()) {
            BlockState stateBelow = level.getBlockState(target.blockPosition().below());
            level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, stateBelow), target.getX(), target.getY(), target.getZ(), 0.0, 0.1, 0.0);
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        if (state.is(Blocks.STONE) || state.is(BlockTags.MINEABLE_WITH_PICKAXE)) {
            return 8.0f;
        }
        return super.getDestroySpeed(stack, state);
    }

    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repairWith) {
        return repairWith.is(Items.NETHERITE_INGOT) || super.isValidRepairItem(toRepair, repairWith);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"item.hyrule_terrors.boulder_breaker.tooltip").withStyle(ChatFormatting.RED));
            tooltipComponents.add((Component)Component.translatable((String)"item.hyrule_terrors.boulder_breaker.tooltip1").withStyle(ChatFormatting.GRAY));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"item.hyrule_terrors.hold_shift").withStyle(ChatFormatting.DARK_GRAY));
        }
    }
}

