/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.hyrule_terrors.item.armor.sets;

import java.util.List;
import net.bandit.hyrule_terrors.item.armor.ZeldaArmorMaterials;
import net.bandit.hyrule_terrors.item.armor.client.dispatcher.ZeldaArmorDispatcher;
import net.bandit.hyrule_terrors.registry.ItemRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ZoraArmorItem
extends ArmorItem {
    public final ZeldaArmorDispatcher DISPATCHER = new ZeldaArmorDispatcher();

    public ZoraArmorItem(ArmorItem.Type type, Item.Properties properties) {
        super(ZeldaArmorMaterials.ZORA_ARMOR, type, properties);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        Player player;
        if (!level.isClientSide() && entity instanceof Player && this.hasFullSet((LivingEntity)(player = (Player)entity)) && player.isInWater()) {
            player.addEffect(new MobEffectInstance(MobEffects.WATER_BREATHING, 220, 0, false, false, true));
            player.setDeltaMovement(player.getDeltaMovement().multiply(1.2, 1.0, 1.2));
        }
    }

    private boolean hasFullSet(LivingEntity entity) {
        return entity.getItemBySlot(EquipmentSlot.HEAD).getItem() instanceof ZoraArmorItem && entity.getItemBySlot(EquipmentSlot.CHEST).getItem() instanceof ZoraArmorItem && entity.getItemBySlot(EquipmentSlot.LEGS).getItem() instanceof ZoraArmorItem && entity.getItemBySlot(EquipmentSlot.FEET).getItem() instanceof ZoraArmorItem;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.hyrule_terrors.zora_armor.tooltip").withStyle(ChatFormatting.AQUA).withStyle(ChatFormatting.ITALIC));
    }

    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repair) {
        return repair.is((Item)ItemRegistry.CHUCHU_JELLY.get());
    }
}

