/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.hyrule_terrors.entity.attack;

import java.util.EnumSet;
import java.util.Random;
import net.bandit.hyrule_terrors.entity.mobs.Keese;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class FlyingAttackGoal
extends Goal {
    private final Mob mob;
    private LivingEntity target;
    private final double speed;
    private int attackCooldown = 0;
    private int circlingTime = 0;
    private final Random random = new Random();

    public FlyingAttackGoal(Mob mob, double speed) {
        this.mob = mob;
        this.speed = speed;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        this.target = this.mob.getTarget();
        return this.target != null && this.target.isAlive();
    }

    public void tick() {
        if (this.target == null) {
            return;
        }
        double distance = this.mob.distanceToSqr((Entity)this.target);
        if (this.circlingTime > 0) {
            --this.circlingTime;
            double angle = this.random.nextFloat() * 360.0f;
            double radius = 3.0;
            double x = this.target.getX() + Math.cos(angle) * radius;
            double z = this.target.getZ() + Math.sin(angle) * radius;
            double y = this.target.getY() + 1.5 + ((double)this.random.nextFloat() - 0.5) * 1.5;
            this.mob.getMoveControl().setWantedPosition(x, y, z, this.speed * 0.8);
        } else {
            if (distance > 2.5) {
                Vec3 direction = new Vec3(this.target.getX() - this.mob.getX(), this.target.getY() - this.mob.getY() + 1.5, this.target.getZ() - this.mob.getZ()).normalize();
                this.mob.setDeltaMovement(direction.scale(this.speed * 0.8));
            }
            if (distance < 2.5 && this.attackCooldown == 0) {
                Mob mob = this.mob;
                if (mob instanceof Keese) {
                    Keese keese = (Keese)mob;
                    keese.dispatcher.attack();
                }
                this.mob.doHurtTarget((Entity)this.target);
                this.attackCooldown = 30;
                this.circlingTime = 40 + this.random.nextInt(20);
            }
        }
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
    }
}

