/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.hyrule_terrors.entity.ai;

import java.util.EnumSet;
import net.bandit.hyrule_terrors.entity.mobs.Lizalfos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class SneakyCrawlGoal
extends Goal {
    private final Lizalfos lizalfos;
    private final double crawlSpeed;

    public SneakyCrawlGoal(Lizalfos lizalfos, double speed) {
        this.lizalfos = lizalfos;
        this.crawlSpeed = speed;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        LivingEntity target = this.lizalfos.getTarget();
        return target != null && (double)this.lizalfos.distanceTo((Entity)target) < 6.0 && (double)this.lizalfos.distanceTo((Entity)target) > 2.0;
    }

    public void start() {
        this.lizalfos.dispatcher.crawl();
    }

    public void tick() {
        if (this.lizalfos.getTarget() != null) {
            this.lizalfos.getNavigation().moveTo((Entity)this.lizalfos.getTarget(), this.crawlSpeed);
            if (!this.lizalfos.isInWater() && this.lizalfos.onGround()) {
                this.lizalfos.dispatcher.crawl();
            }
        }
    }

    public void stop() {
        if (!this.lizalfos.getNavigation().isInProgress()) {
            if (this.lizalfos.hurtTime > 0) {
                this.lizalfos.dispatcher.crawl();
            } else {
                this.lizalfos.dispatcher.idle();
            }
        }
    }
}

