/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.hyrule_terrors.entity.ai;

import java.util.EnumSet;
import java.util.Random;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;

public class RandomFlyingGoal
extends Goal {
    private final Mob mob;
    private final double speed;
    private int idleTime = 0;
    private final Random random = new Random();

    public RandomFlyingGoal(Mob mob, double speed) {
        this.mob = mob;
        this.speed = speed;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        return this.mob.getTarget() == null;
    }

    public void tick() {
        if (this.idleTime > 0) {
            --this.idleTime;
            return;
        }
        double x = this.mob.getX() + ((double)this.random.nextFloat() - 0.5) * 8.0;
        double y = this.mob.getY() + ((double)this.random.nextFloat() - 0.2) * 2.5;
        double z = this.mob.getZ() + ((double)this.random.nextFloat() - 0.5) * 8.0;
        this.mob.getMoveControl().setWantedPosition(x, y, z, this.speed);
        this.idleTime = 40 + this.random.nextInt(60);
    }
}

