/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.hostilenetworks.client;

import dev.shadowsoffire.hostilenetworks.Hostile;
import dev.shadowsoffire.hostilenetworks.HostileConfig;
import dev.shadowsoffire.hostilenetworks.HostileNetworks;
import dev.shadowsoffire.hostilenetworks.client.WeirdRenderThings;
import dev.shadowsoffire.hostilenetworks.curios.CuriosCompat;
import dev.shadowsoffire.hostilenetworks.data.DataModelInstance;
import dev.shadowsoffire.hostilenetworks.item.DeepLearnerItem;
import dev.shadowsoffire.placebo.util.Offset;
import java.util.ArrayList;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.items.ComponentItemHandler;

public class DeepLearnerHudRenderer
implements LayeredDraw.Layer {
    public static final ResourceLocation DL_HUD = HostileNetworks.loc("textures/gui/deep_learner_hud.png");
    public static final ResourceLocation DL_HUD_BG = HostileNetworks.loc("dl_hud_bg");
    public static final int SPACING = 28;

    public void render(GuiGraphics gfx, DeltaTracker deltaTracker) {
        DataModelInstance cModel;
        int i;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null || !(mc.screen instanceof ChatScreen) && mc.screen != null) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        if (!stack.is(Hostile.Items.DEEP_LEARNER)) {
            stack = player.getOffhandItem();
        }
        if (!stack.is(Hostile.Items.DEEP_LEARNER) && ModList.get().isLoaded("curios")) {
            stack = CuriosCompat.getDeepLearner((Player)player);
        }
        if (!stack.is(Hostile.Items.DEEP_LEARNER)) {
            return;
        }
        ComponentItemHandler inv = DeepLearnerItem.getItemHandler(stack);
        ArrayList<DataModelInstance> renderable = new ArrayList<DataModelInstance>(4);
        for (int i2 = 0; i2 < 4; ++i2) {
            DataModelInstance cModel2;
            ItemStack model = inv.getStackInSlot(i2);
            if (model.isEmpty() || !(cModel2 = new DataModelInstance(model, 0)).isValid()) continue;
            renderable.add(cModel2);
        }
        if (renderable.isEmpty()) {
            return;
        }
        gfx.pose().pushPose();
        Offset offset = HostileConfig.deepLearnerOffset;
        Offset.Box window = new Offset.Box(mc.getWindow().getGuiScaledWidth(), mc.getWindow().getGuiScaledHeight());
        Offset.Box element = new Offset.Box(119, 10 + 28 * renderable.size());
        offset.apply(gfx.pose(), window, element);
        int x = 6;
        int y = 6;
        WeirdRenderThings.TRANSLUCENT_TRANSPARENCY.setupRenderState();
        gfx.blitSprite(DL_HUD_BG, 3, 3, 113, 5 + 28 * renderable.size());
        for (i = 0; i < renderable.size(); ++i) {
            cModel = (DataModelInstance)renderable.get(i);
            gfx.blit(DL_HUD, x + 18, y + i * 28 + 11, 0.0f, 0.0f, 89, 12, 256, 256);
            int width = 87;
            if (!cModel.getTier().isMax()) {
                int prev = cModel.getTierData();
                width = Mth.ceil((float)((float)(width * (cModel.getData() - prev)) / (float)(cModel.getNextTierData() - prev)));
            }
            gfx.blit(DL_HUD, x + 19, y + i * 28 + 12, 0.0f, 12.0f, width, 10, 256, 256);
        }
        WeirdRenderThings.TRANSLUCENT_TRANSPARENCY.clearRenderState();
        for (i = 0; i < renderable.size(); ++i) {
            ItemStack dModel = ((DataModelInstance)renderable.get(i)).getSourceStack();
            gfx.renderItem(dModel, x, y + i * 28 + 9);
        }
        for (i = 0; i < renderable.size(); ++i) {
            cModel = (DataModelInstance)renderable.get(i);
            Component comp = cModel.getTier().getComponent();
            gfx.drawString(mc.font, comp, x + 2, y + 28 * i, 0xFFFFFF, true);
            gfx.drawString(mc.font, (Component)Component.translatable((String)"hostilenetworks.hud.model").withStyle(comp.getStyle()), x + mc.font.width((FormattedText)comp) + 2, y + 28 * i, 0xFFFFFF, true);
            if (cModel.getTier().isMax()) continue;
            gfx.drawString(mc.font, I18n.get((String)"hostilenetworks.hud.kills", (Object[])new Object[]{cModel.getKillsNeeded()}), x + 21, y + 13 + i * 28, 0xFFFFFF, true);
        }
        gfx.pose().popPose();
    }
}

