/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.hostilenetworks;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.datafixers.util.Either;
import dev.shadowsoffire.hostilenetworks.Hostile;
import dev.shadowsoffire.hostilenetworks.HostileConfig;
import dev.shadowsoffire.hostilenetworks.HostileNetworks;
import dev.shadowsoffire.hostilenetworks.client.DataModelTooltipRenderer;
import dev.shadowsoffire.hostilenetworks.client.DeepLearnerHudRenderer;
import dev.shadowsoffire.hostilenetworks.data.DataModel;
import dev.shadowsoffire.hostilenetworks.data.DataModelInstance;
import dev.shadowsoffire.hostilenetworks.gui.DeepLearnerScreen;
import dev.shadowsoffire.hostilenetworks.gui.LootFabScreen;
import dev.shadowsoffire.hostilenetworks.gui.SimChamberScreen;
import dev.shadowsoffire.hostilenetworks.item.DataModelItem;
import dev.shadowsoffire.hostilenetworks.item.DeepLearnerItem;
import dev.shadowsoffire.hostilenetworks.net.OpenDeepLearnerPayload;
import dev.shadowsoffire.placebo.config.Configuration;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import dev.shadowsoffire.placebo.util.Offset;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import net.neoforged.neoforge.items.ComponentItemHandler;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT}, modid="hostilenetworks")
public class HostileClient {
    public static final KeyMapping KEY_OPEN_DEEP_LEARNER = new KeyMapping("key.hostilenetworks.open_deep_learner", 85, "key.categories.hostilenetworks");

    @SubscribeEvent
    public static void mrl(ModelEvent.RegisterAdditional e) {
        e.register(ModelResourceLocation.standalone((ResourceLocation)HostileNetworks.loc("item/data_model_base")));
    }

    @SubscribeEvent
    public static void colors(RegisterColorHandlersEvent.Item e) {
        e.register((stack, tint) -> {
            DynamicHolder<DataModel> model = DataModelItem.getStoredModel(stack);
            int color = 0xFFFFFF;
            if (model.isBound()) {
                color = ((DataModel)model.get()).getNameColor();
            }
            return 0xFF000000 | color;
        }, new ItemLike[]{(ItemLike)Hostile.Items.PREDICTION.value()});
    }

    @SubscribeEvent
    public static void overlays(RegisterGuiLayersEvent e) {
        e.registerAboveAll(HostileNetworks.loc("deep_learner"), (LayeredDraw.Layer)new DeepLearnerHudRenderer());
    }

    @SubscribeEvent
    public static void screens(RegisterMenuScreensEvent e) {
        e.register(Hostile.Containers.DEEP_LEARNER, DeepLearnerScreen::new);
        e.register(Hostile.Containers.SIM_CHAMBER, SimChamberScreen::new);
        e.register(Hostile.Containers.LOOT_FABRICATOR, LootFabScreen::new);
    }

    @SubscribeEvent
    public static void tooltipComps(RegisterClientTooltipComponentFactoriesEvent e) {
        e.register(DataModelInstance.class, DataModelTooltipRenderer::new);
    }

    @SubscribeEvent
    public static void keys(RegisterKeyMappingsEvent e) {
        e.register(KEY_OPEN_DEEP_LEARNER);
    }

    @EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT}, modid="hostilenetworks")
    public static class GameBusEvents {
        @SubscribeEvent
        public static void commands(RegisterClientCommandsEvent e) {
            e.getDispatcher().register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"hnn_client").then(LiteralArgumentBuilder.literal((String)"set_hud_pos").then(((RequiredArgumentBuilder)Commands.argument((String)"anchor", (ArgumentType)StringArgumentType.string()).suggests(Offset.AnchorPoint.SUGGEST_ANCHOR_POINT).executes(c -> {
                GameBusEvents.updateHudPos(Offset.AnchorPoint.parse((String)((String)c.getArgument("anchor", String.class))), 0, 0);
                return 0;
            })).then(Commands.argument((String)"x", (ArgumentType)IntegerArgumentType.integer((int)-1000, (int)1000)).then(Commands.argument((String)"y", (ArgumentType)IntegerArgumentType.integer((int)-1000, (int)1000)).executes(c -> {
                GameBusEvents.updateHudPos(Offset.AnchorPoint.parse((String)((String)c.getArgument("anchor", String.class))), (Integer)c.getArgument("x", Integer.class), (Integer)c.getArgument("y", Integer.class));
                return 0;
            }))))));
        }

        @SubscribeEvent
        public static void comps(RenderTooltipEvent.GatherComponents e) {
            ItemStack stack = e.getItemStack();
            if (stack.is(Hostile.Items.DEEP_LEARNER)) {
                List list = e.getTooltipElements();
                int rmvIdx = -1;
                for (int i = 0; i < list.size(); ++i) {
                    PlainTextContents.LiteralContents tc;
                    Component comp;
                    Object object;
                    Optional o = ((Either)list.get(i)).left();
                    if (!o.isPresent() || !((object = o.get()) instanceof Component) || !((object = (comp = (Component)object).getContents()) instanceof PlainTextContents.LiteralContents) || !"DL_INV_MARKER".equals((tc = (PlainTextContents.LiteralContents)object).text())) continue;
                    rmvIdx = i;
                    list.remove(i);
                    break;
                }
                if (rmvIdx != -1) {
                    ComponentItemHandler inv = DeepLearnerItem.getItemHandler(stack);
                    for (int i = 3; i >= 0; --i) {
                        DataModelInstance model = new DataModelInstance(inv.getStackInSlot(i), i);
                        if (!model.isValid()) continue;
                        e.getTooltipElements().add(rmvIdx, Either.right((Object)model));
                    }
                }
            }
        }

        @SubscribeEvent
        public static void tick(ClientTickEvent.Post e) {
            if (KEY_OPEN_DEEP_LEARNER.consumeClick() && Minecraft.getInstance().screen == null) {
                PacketDistributor.sendToServer((CustomPacketPayload)OpenDeepLearnerPayload.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        @SubscribeEvent
        public static void tooltipColors(RenderTooltipEvent.Color e) {
            if (e.getItemStack().is(Hostile.Tags.CUSTOM_TOOLTIP_BORDER)) {
                e.setBorderStart(-939458624);
                e.setBorderEnd(-933046017);
                e.setBackground(-267316975);
            }
        }

        private static void updateHudPos(Offset.AnchorPoint anchor, int x, int y) {
            Configuration cfg = HostileNetworks.cfg;
            HostileConfig.deepLearnerOffset = new Offset(anchor, x, y);
            Offset.save((String)"Deep Learner HUD", (String)"client", (Offset)HostileConfig.deepLearnerOffset, (Configuration)cfg);
        }
    }
}

