/*
 * Decompiled with CFR 0.152.
 */
package fuzs.hoppergadgetry.world.level.block.entity;

import fuzs.hoppergadgetry.HopperGadgetry;
import fuzs.hoppergadgetry.init.ModRegistry;
import fuzs.hoppergadgetry.world.inventory.GratedHopperMenu;
import fuzs.puzzleslib.api.block.v1.entity.TickingBlockEntity;
import fuzs.puzzleslib.api.container.v1.ContainerMenuHelper;
import fuzs.puzzleslib.api.container.v1.ContainerSerializationHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class GratedHopperBlockEntity
extends HopperBlockEntity
implements TickingBlockEntity {
    public static final Component COMPONENT_GRATED_HOPPER = Component.translatable((String)"container.grated_hopper");
    public static final String TAG_FILTER = HopperGadgetry.id("filter").toString();
    private final NonNullList<ItemStack> filterItems = NonNullList.withSize((int)5, (Object)ItemStack.EMPTY);

    public GratedHopperBlockEntity(BlockPos pos, BlockState blockState) {
        super(pos, blockState);
    }

    public BlockEntityType<?> getType() {
        return (BlockEntityType)ModRegistry.GRATED_HOPPER_BLOCK_ENTITY_TYPE.value();
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.filterItems.clear();
        ContainerSerializationHelper.loadAllItems((String)TAG_FILTER, (CompoundTag)tag, this.filterItems, (HolderLookup.Provider)registries);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ContainerSerializationHelper.saveAllItems((String)TAG_FILTER, (CompoundTag)tag, this.filterItems, (HolderLookup.Provider)registries);
    }

    protected Component getDefaultName() {
        return COMPONENT_GRATED_HOPPER;
    }

    protected AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return new GratedHopperMenu(containerId, inventory, (Container)this, this.getFilterContainer());
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        boolean isEmpty = true;
        for (ItemStack filter : this.filterItems) {
            if (filter.isEmpty()) continue;
            if (ItemStack.isSameItemSameComponents((ItemStack)filter, (ItemStack)stack)) {
                return true;
            }
            isEmpty = false;
        }
        return isEmpty;
    }

    public void serverTick() {
        GratedHopperBlockEntity.pushItemsTick(this.getLevel(), this.getBlockPos(), this.getBlockState(), this);
    }

    public static void pushItemsTick(Level level, BlockPos pos, BlockState state, HopperBlockEntity blockEntity) {
        --blockEntity.cooldownTime;
        blockEntity.tickedGameTime = level.getGameTime();
        if (!blockEntity.isOnCooldown()) {
            blockEntity.setCooldown(0);
            HopperBlockEntity.tryMoveItems((Level)level, (BlockPos)pos, (BlockState)state, (HopperBlockEntity)blockEntity, () -> GratedHopperBlockEntity.suckInItems(level, (Hopper)blockEntity));
        }
    }

    public static boolean suckInItems(Level level, Hopper hopper) {
        BlockState blockState;
        BlockPos blockPos = BlockPos.containing((double)hopper.getLevelX(), (double)(hopper.getLevelY() + 1.0), (double)hopper.getLevelZ());
        Container container = HopperBlockEntity.getSourceContainer((Level)level, (Hopper)hopper, (BlockPos)blockPos, (BlockState)(blockState = level.getBlockState(blockPos)));
        if (container != null) {
            Direction direction = Direction.DOWN;
            for (int slot : GratedHopperBlockEntity.getSlots((Container)container, (Direction)direction)) {
                ItemStack itemStack = container.getItem(slot);
                if (!hopper.canPlaceItem(0, itemStack) || !GratedHopperBlockEntity.tryTakeInItemFromSlot((Hopper)hopper, (Container)container, (int)slot, (Direction)direction)) continue;
                return true;
            }
            return false;
        }
        for (ItemEntity itemEntity : HopperBlockEntity.getItemsAtAndAbove((Level)level, (Hopper)hopper)) {
            ItemStack itemStack = itemEntity.getItem();
            if (!hopper.canPlaceItem(0, itemStack) || !HopperBlockEntity.addItem((Container)hopper, (ItemEntity)itemEntity)) continue;
            return true;
        }
        return false;
    }

    public Container getFilterContainer() {
        return ContainerMenuHelper.createListBackedContainer(this.filterItems, (Container)this);
    }

    public static void entityInside(Level level, BlockPos blockPos, BlockState blockState, Entity entity, HopperBlockEntity blockEntity) {
        ItemEntity itemEntity;
        if (entity instanceof ItemEntity && !(itemEntity = (ItemEntity)entity).getItem().isEmpty() && entity.getBoundingBox().move((double)(-blockPos.getX()), (double)(-blockPos.getY()), (double)(-blockPos.getZ())).intersects(blockEntity.getSuckAabb())) {
            GratedHopperBlockEntity.tryMoveItems((Level)level, (BlockPos)blockPos, (BlockState)blockState, (HopperBlockEntity)blockEntity, () -> {
                ItemStack itemStack = itemEntity.getItem();
                return blockEntity.canPlaceItem(0, itemStack) && GratedHopperBlockEntity.addItem((Container)blockEntity, (ItemEntity)itemEntity);
            });
        }
    }
}

