/*
 * Decompiled with CFR 0.152.
 */
package fuzs.goldenagecombat.mixin;

import fuzs.goldenagecombat.GoldenAgeCombat;
import fuzs.goldenagecombat.config.ServerConfig;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FishingHook.class})
abstract class FishingHookMixin
extends Projectile {
    public FishingHookMixin(EntityType<? extends Projectile> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"onHitEntity"}, at={@At(value="TAIL")})
    protected void onHitEntity(EntityHitResult hitResult, CallbackInfo callback) {
        if (!((ServerConfig)GoldenAgeCombat.CONFIG.get(ServerConfig.class)).fishingRodKnockback) {
            return;
        }
        hitResult.getEntity().hurt(this.damageSources().thrown((Entity)this, (Entity)this.getPlayerOwner()), 0.0f);
    }

    @Shadow
    public abstract Player getPlayerOwner();

    @Inject(method={"pullEntity"}, at={@At(value="HEAD")}, cancellable=true)
    protected void pullEntity(Entity entity, CallbackInfo callback) {
        if (!((ServerConfig)GoldenAgeCombat.CONFIG.get(ServerConfig.class)).fishingRodLaunch) {
            return;
        }
        Entity owner = this.getOwner();
        if (owner != null) {
            Vec3 vec3 = new Vec3(owner.getX() - this.getX(), owner.getY() - this.getY(), owner.getZ() - this.getZ()).scale(0.1);
            Vec3 deltaMovement = entity.getDeltaMovement();
            double x = deltaMovement.x() * 10.0;
            double y = deltaMovement.y() * 10.0;
            double z = deltaMovement.z() * 10.0;
            deltaMovement = deltaMovement.add(0.0, Math.pow(x * x + y * y + z * z, 0.25) * 0.08, 0.0);
            entity.setDeltaMovement(deltaMovement.add(vec3));
            callback.cancel();
        }
    }

    @Inject(method={"retrieve"}, at={@At(value="RETURN")}, cancellable=true)
    public void retrieve(ItemStack stack, CallbackInfoReturnable<Integer> callback) {
        if (!((ServerConfig)GoldenAgeCombat.CONFIG.get(ServerConfig.class)).fishingRodSlowerBreaking) {
            return;
        }
        if (callback.getReturnValueI() == 5) {
            callback.setReturnValue((Object)3);
        }
    }
}

