/*
 * Decompiled with CFR 0.152.
 */
package fuzs.goldenagecombat.handler;

import com.google.common.collect.ImmutableMap;
import fuzs.goldenagecombat.GoldenAgeCombat;
import fuzs.goldenagecombat.config.CommonConfig;
import fuzs.puzzleslib.api.config.v3.serialization.ConfigDataSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;

public class AttackAttributeHandler {
    private static final Map<Class<? extends TieredItem>, Double> ATTACK_DAMAGE_BONUS_OVERRIDES = ImmutableMap.of(SwordItem.class, (Object)4.0, AxeItem.class, (Object)3.0, PickaxeItem.class, (Object)2.0, ShovelItem.class, (Object)1.0, HoeItem.class, (Object)0.0);

    public static void onFinalizeItemComponents(Item item, Consumer<Function<DataComponentMap, DataComponentPatch>> consumer) {
        if (!GoldenAgeCombat.CONFIG.getHolder(CommonConfig.class).isAvailable()) {
            return;
        }
        if (!((CommonConfig)GoldenAgeCombat.CONFIG.get(CommonConfig.class)).noItemDurabilityPenalty) {
            return;
        }
        if (item instanceof SwordItem) {
            consumer.accept(dataComponents -> {
                Tool tool;
                if (dataComponents.has(DataComponents.TOOL) && (tool = (Tool)dataComponents.get(DataComponents.TOOL)).damagePerBlock() == 2) {
                    Tool newTool = new Tool(tool.rules(), tool.defaultMiningSpeed(), 1);
                    return DataComponentPatch.builder().set(DataComponents.TOOL, (Object)newTool).build();
                }
                return DataComponentPatch.EMPTY;
            });
        }
    }

    public static void onComputeItemAttributeModifiers(Item item, List<ItemAttributeModifiers.Entry> itemAttributeModifiers) {
        if (!GoldenAgeCombat.CONFIG.getHolder(CommonConfig.class).isAvailable()) {
            return;
        }
        if (!AttackAttributeHandler.setAttributeValue(item, itemAttributeModifiers, (Holder<Attribute>)Attributes.ATTACK_DAMAGE, Item.BASE_ATTACK_DAMAGE_ID, ((CommonConfig)GoldenAgeCombat.CONFIG.get(CommonConfig.class)).attackDamageOverrides) && ((CommonConfig)GoldenAgeCombat.CONFIG.get(CommonConfig.class)).oldAttackDamage) {
            for (Map.Entry<Class<? extends TieredItem>, Double> entry : ATTACK_DAMAGE_BONUS_OVERRIDES.entrySet()) {
                if (!entry.getKey().isInstance(item)) continue;
                AttackAttributeHandler.setAttributeValue(itemAttributeModifiers, (Holder<Attribute>)Attributes.ATTACK_DAMAGE, Item.BASE_ATTACK_DAMAGE_ID, (double)((TieredItem)item).getTier().getAttackDamageBonus() + entry.getValue());
                break;
            }
        }
    }

    private static boolean setAttributeValue(Item item, List<ItemAttributeModifiers.Entry> itemAttributeModifiers, Holder<Attribute> attribute, ResourceLocation id, ConfigDataSet<Item> attackDamageOverrides) {
        if (attackDamageOverrides.contains((Object)item)) {
            double newValue = (Double)attackDamageOverrides.getOptional((Object)item, 0).orElseThrow();
            AttackAttributeHandler.setAttributeValue(itemAttributeModifiers, attribute, id, newValue);
            return true;
        }
        return false;
    }

    private static void setAttributeValue(List<ItemAttributeModifiers.Entry> itemAttributeModifiers, Holder<Attribute> attribute, ResourceLocation id, double newValue) {
        AttributeModifier attributeModifier = new AttributeModifier(id, newValue, AttributeModifier.Operation.ADD_VALUE);
        ItemAttributeModifiers.Entry newEntry = new ItemAttributeModifiers.Entry(attribute, attributeModifier, EquipmentSlotGroup.MAINHAND);
        ListIterator<ItemAttributeModifiers.Entry> iterator = itemAttributeModifiers.listIterator();
        while (iterator.hasNext()) {
            ItemAttributeModifiers.Entry entry = iterator.next();
            if (entry.slot() != EquipmentSlotGroup.MAINHAND || !entry.matches(attribute, id)) continue;
            iterator.set(newEntry);
            return;
        }
        itemAttributeModifiers.add(newEntry);
    }
}

