/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.gateways.gate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.gateways.GatewayObjects;
import dev.shadowsoffire.gateways.Gateways;
import dev.shadowsoffire.gateways.entity.GatewayEntity;
import dev.shadowsoffire.gateways.event.GateEvent;
import dev.shadowsoffire.gateways.gate.GateRules;
import dev.shadowsoffire.gateways.gate.Reward;
import dev.shadowsoffire.gateways.gate.WaveEntity;
import dev.shadowsoffire.gateways.gate.WaveModifier;
import dev.shadowsoffire.gateways.payloads.ParticlePayload;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;

public record Wave(List<WaveEntity> entities, List<WaveModifier> modifiers, List<Reward> rewards, int maxWaveTime, int setupTime) {
    public static Codec<Wave> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)WaveEntity.CODEC.listOf().fieldOf("entities").forGetter(Wave::entities), (App)WaveModifier.CODEC.listOf().optionalFieldOf("modifiers", Collections.emptyList()).forGetter(Wave::modifiers), (App)Reward.CODEC.listOf().optionalFieldOf("rewards", Collections.emptyList()).forGetter(Wave::rewards), (App)Codec.INT.fieldOf("max_wave_time").forGetter(Wave::maxWaveTime), (App)Codec.INT.fieldOf("setup_time").forGetter(Wave::setupTime)).apply((Applicative)inst, Wave::new));

    public List<LivingEntity> spawnWave(ServerLevel level, Vec3 pos, GatewayEntity gate) {
        ArrayList<LivingEntity> spawned = new ArrayList<LivingEntity>();
        block0: for (WaveEntity toSpawn : this.entities) {
            for (int i = 0; i < toSpawn.getCount(); ++i) {
                LivingEntity entity = Wave.spawnWaveEntity(level, pos, gate, this, toSpawn);
                if (entity == null) {
                    gate.onFailure(spawned, GatewayEntity.FailureReason.SPAWN_FAILED);
                    continue block0;
                }
                spawned.add(entity);
            }
        }
        return spawned;
    }

    public List<ItemStack> spawnRewards(ServerLevel level, GatewayEntity gate, Player summoner) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        this.rewards.forEach(r -> r.generateLoot(level, gate, summoner, s -> {
            if (!s.isEmpty()) {
                while (s.getCount() > 4) {
                    ItemStack copy = s.copy();
                    copy.setCount(4);
                    stacks.add(copy);
                    s.shrink(4);
                }
                if (!s.isEmpty()) {
                    stacks.add((ItemStack)s);
                }
            }
        }));
        return stacks;
    }

    @Nullable
    public static LivingEntity spawnWaveEntity(ServerLevel level, Vec3 pos, GatewayEntity gate, Wave wave, WaveEntity waveEntity) {
        AttributeInstance attr;
        LivingEntity entity = waveEntity.createEntity(level, gate);
        if (entity == null) {
            return null;
        }
        Vec3 spawnPos = gate.getGateway().spawnAlgo().spawn(level, pos, gate, (Entity)entity);
        if (spawnPos == null) {
            return null;
        }
        entity.getPersistentData().putUUID("gateways.owner", gate.getUUID());
        entity.moveTo(spawnPos.x(), spawnPos.y(), spawnPos.z(), level.random.nextFloat() * 360.0f, level.random.nextFloat() * 360.0f);
        entity.getPassengersAndSelf().filter(e -> e instanceof LivingEntity).map(LivingEntity.class::cast).forEach(e -> {
            wave.modifiers.forEach(m -> m.apply((LivingEntity)e));
            e.setHealth(entity.getMaxHealth());
            e.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 5, 100, true, false));
        });
        GateRules rules = gate.getGateway().rules();
        if (entity instanceof Mob) {
            Player summoner;
            Mob mob = (Mob)entity;
            if (waveEntity.shouldFinalizeSpawn()) {
                EventHooks.finalizeMobSpawn((Mob)mob, (ServerLevelAccessor)level, (DifficultyInstance)level.getCurrentDifficultyAt(entity.blockPosition()), (MobSpawnType)MobSpawnType.SPAWNER, null);
            }
            if (!((summoner = gate.summonerOrClosest()) instanceof FakePlayer)) {
                mob.setTarget((LivingEntity)summoner);
            }
            mob.setPersistenceRequired();
            if (rules.defaultDropChance() >= 0.0f) {
                int i;
                for (i = 0; i < 2; ++i) {
                    if (mob.handDropChances[i] != 0.085f) continue;
                    mob.handDropChances[i] = rules.defaultDropChance();
                }
                for (i = 0; i < 4; ++i) {
                    if (mob.armorDropChances[i] != 0.085f) continue;
                    mob.armorDropChances[i] = rules.defaultDropChance();
                }
            }
        }
        if (rules.followRangeBoost() > 0.0 && (attr = entity.getAttribute(Attributes.FOLLOW_RANGE)) != null) {
            attr.addPermanentModifier(new AttributeModifier(Gateways.loc("follow_range_boost"), rules.followRangeBoost(), AttributeModifier.Operation.ADD_VALUE));
        }
        NeoForge.EVENT_BUS.post((Event)new GateEvent.WaveEntitySpawned(gate, entity));
        level.addFreshEntityWithPassengers((Entity)entity);
        level.playSound(null, gate.getX(), gate.getY(), gate.getZ(), GatewayObjects.GATE_WARP, SoundSource.HOSTILE, 0.5f, 1.0f);
        gate.spawnParticle(entity.getX(), entity.getY(), entity.getZ(), ParticlePayload.EffectType.SPAWNED);
        return entity;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<WaveEntity> entities = new ArrayList<WaveEntity>();
        private final List<WaveModifier> modifiers = new ArrayList<WaveModifier>();
        private final List<Reward> rewards = new ArrayList<Reward>();
        private int maxWaveTime;
        private int setupTime;

        public Builder entity(WaveEntity entity) {
            this.entities.add(entity);
            return this;
        }

        public Builder entities(List<WaveEntity> entities) {
            this.entities.addAll(entities);
            return this;
        }

        public Builder modifier(WaveModifier modifier) {
            this.modifiers.add(modifier);
            return this;
        }

        public Builder modifiers(List<WaveModifier> modifiers) {
            this.modifiers.addAll(modifiers);
            return this;
        }

        public Builder reward(Reward reward) {
            this.rewards.add(reward);
            return this;
        }

        public Builder rewards(List<Reward> rewards) {
            this.rewards.addAll(rewards);
            return this;
        }

        public Builder maxWaveTime(int maxWaveTime) {
            this.maxWaveTime = maxWaveTime;
            return this;
        }

        public Builder setupTime(int setupTime) {
            this.setupTime = setupTime;
            return this;
        }

        public Wave build() {
            if (this.entities.isEmpty()) {
                throw new IllegalStateException("Wave must have at least one entity");
            }
            if (this.maxWaveTime <= 0) {
                throw new IllegalStateException("Maximum wave time must be positive");
            }
            if (this.setupTime < 0) {
                throw new IllegalStateException("Setup time cannot be negative");
            }
            return new Wave(Collections.unmodifiableList(new ArrayList<WaveEntity>(this.entities)), Collections.unmodifiableList(new ArrayList<WaveModifier>(this.modifiers)), Collections.unmodifiableList(new ArrayList<Reward>(this.rewards)), this.maxWaveTime, this.setupTime);
        }
    }
}

