/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.menu;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.Arrays;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.common.compat.ae2.AppliedEnergisticsCompat;
import xfacthd.framedblocks.common.crafting.FramingSawRecipe;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.menu.FramingSawMenu;

public class FramingSawWithEncoderMenu
extends FramingSawMenu {
    public static final int SLOT_PATTERN_INPUT = 41;
    public static final int SLOT_PATTERN_OUTPUT = 42;
    public static final int MENU_BUTTON_MODE_CRAFTING = -1;
    public static final int MENU_BUTTON_MODE_ENCODING = -2;
    private final Slot patternInputSlot;
    private final Slot patternOutputSlot;
    private final Container encoderContainer = new SimpleContainer(2);
    private final EncoderModeDataSlot patternEncoderMode = new EncoderModeDataSlot(this);
    private BooleanConsumer encoderModeListener;

    FramingSawWithEncoderMenu(int containerId, Inventory inv, ContainerLevelAccess levelAccess) {
        super(containerId, inv, levelAccess);
        Preconditions.checkState((boolean)AppliedEnergisticsCompat.isLoaded(), (Object)"FramingSawWithEncoderMenu requires AE2, how did we get here???");
        this.patternInputSlot = this.addSlot(new EncoderInputSlot(this, this.encoderContainer, 0, 223, 73));
        this.patternOutputSlot = this.addSlot(new EncoderOutputSlot(this, this.encoderContainer, 1, 223, 109));
        this.addDataSlot(this.patternEncoderMode);
        if (!this.level.isClientSide()) {
            levelAccess.execute((level, pos) -> {
                boolean encoder = (Boolean)level.getBlockState(pos).getValue((Property)PropertyHolder.SAW_ENCODER);
                this.patternEncoderMode.set(encoder ? 1 : 0);
            });
        }
    }

    @Override
    public ItemStack quickMoveStack(Player player, int index) {
        if (this.isInEncoderMode()) {
            ItemStack remainder = ItemStack.EMPTY;
            Slot slot = (Slot)this.slots.get(index);
            if (slot.hasItem()) {
                ItemStack stack = slot.getItem();
                remainder = stack.copy();
                if (index == 41 || index == 42 ? !this.moveItemStackTo(stack, 5, 41, true) : index >= 5 && (AppliedEnergisticsCompat.isPattern(stack, false) ? !this.moveItemStackTo(stack, 41, 42, false) : AppliedEnergisticsCompat.isPattern(stack, true) && !this.moveItemStackTo(stack, 42, 43, false))) {
                    return ItemStack.EMPTY;
                }
                if (stack.isEmpty()) {
                    slot.set(ItemStack.EMPTY);
                } else {
                    slot.setChanged();
                }
                if (stack.getCount() == remainder.getCount()) {
                    return ItemStack.EMPTY;
                }
                slot.onTake(player, stack);
                this.broadcastChanges();
            }
            return remainder;
        }
        return super.quickMoveStack(player, index);
    }

    @Override
    public boolean clickMenuButton(Player player, int id) {
        if (!this.level.isClientSide()) {
            if (id == -1) {
                this.setEncoderMode(player, false);
            } else if (id == -2) {
                this.setEncoderMode(player, true);
            }
        }
        return super.clickMenuButton(player, id);
    }

    private void setEncoderMode(Player player, boolean encoder) {
        if (this.isInEncoderMode() != encoder) {
            this.patternEncoderMode.set(encoder ? 1 : 0);
            this.levelAccess.execute((level, pos) -> {
                this.clearContainer(player, (Container)(encoder ? this.inputContainer : this.encoderContainer));
                this.slotsChanged((Container)(encoder ? this.inputContainer : this.encoderContainer));
                BlockState state = level.getBlockState(pos);
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)PropertyHolder.SAW_ENCODER, (Comparable)Boolean.valueOf(encoder)));
            });
        }
    }

    @Override
    public void removed(Player player) {
        super.removed(player);
        this.levelAccess.execute((level, pos) -> this.clearContainer(player, this.encoderContainer));
    }

    @Override
    protected boolean isCraftingEnabled() {
        return !this.isInEncoderMode();
    }

    public void setEncoderModeListener(BooleanConsumer listener) {
        this.encoderModeListener = listener;
    }

    public boolean isInEncoderMode() {
        return this.patternEncoderMode.isEncoder();
    }

    public void tryEncodePattern(FramingSawRecipe recipe, ItemStack[] inputs) {
        if (!this.patternInputSlot.hasItem() && !this.patternOutputSlot.hasItem()) {
            return;
        }
        ItemStack[] additives = Arrays.copyOfRange(inputs, 1, inputs.length);
        ItemStack pattern = AppliedEnergisticsCompat.tryEncodePattern(inputs[0], additives, recipe.getResult());
        if (pattern != null) {
            if (!this.patternOutputSlot.hasItem()) {
                this.patternInputSlot.getItem().shrink(1);
            }
            this.patternOutputSlot.set(pattern);
            this.broadcastChanges();
        }
    }

    private static class EncoderModeDataSlot
    extends DataSlot {
        private final FramingSawWithEncoderMenu menu;
        private boolean encoder;

        public EncoderModeDataSlot(FramingSawWithEncoderMenu menu) {
            this.menu = menu;
        }

        public int get() {
            return this.encoder ? 1 : 0;
        }

        public void set(int value) {
            boolean bl = this.encoder = value != 0;
            if (this.menu.encoderModeListener != null) {
                this.menu.encoderModeListener.accept(this.encoder);
            }
        }

        public boolean isEncoder() {
            return this.encoder;
        }
    }

    private static class EncoderInputSlot
    extends EncoderSlot {
        public EncoderInputSlot(FramingSawWithEncoderMenu menu, Container pContainer, int pSlot, int pX, int pY) {
            super(menu, pContainer, pSlot, pX, pY);
        }

        public boolean mayPlace(ItemStack stack) {
            return AppliedEnergisticsCompat.isPattern(stack, false);
        }
    }

    private static class EncoderOutputSlot
    extends EncoderSlot {
        public EncoderOutputSlot(FramingSawWithEncoderMenu menu, Container pContainer, int pSlot, int pX, int pY) {
            super(menu, pContainer, pSlot, pX, pY);
        }

        public boolean mayPlace(ItemStack stack) {
            return AppliedEnergisticsCompat.isPattern(stack, true);
        }
    }

    private static class EncoderSlot
    extends Slot {
        private final FramingSawWithEncoderMenu menu;

        public EncoderSlot(FramingSawWithEncoderMenu menu, Container pContainer, int pSlot, int pX, int pY) {
            super(pContainer, pSlot, pX, pY);
            this.menu = menu;
        }

        public boolean isActive() {
            return this.menu.isInEncoderMode();
        }
    }
}

