/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.datagen.providers;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.datagen.loot.FramedBlockLootSubProvider;
import xfacthd.framedblocks.common.FBContent;

public final class FramedLootTableProvider
extends LootTableProvider {
    public FramedLootTableProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> providerFuture) {
        super(output, Set.of(), List.of(new LootTableProvider.SubProviderEntry(BlockLootTable::new, LootContextParamSets.BLOCK)), providerFuture);
    }

    private static class BlockLootTable
    extends FramedBlockLootSubProvider {
        public BlockLootTable(HolderLookup.Provider lookupProvider) {
            super(lookupProvider);
        }

        protected Iterable<Block> getKnownBlocks() {
            return FBContent.getRegisteredBlocks().stream().map(Holder::value).collect(Collectors.toList());
        }

        protected void generate() {
            this.dropOtherWithCamo((Block)FBContent.BLOCK_FRAMED_WATERLOGGABLE_PRESSURE_PLATE.value(), (Block)FBContent.BLOCK_FRAMED_PRESSURE_PLATE.value());
            this.dropOtherWithCamo((Block)FBContent.BLOCK_FRAMED_WATERLOGGABLE_STONE_PRESSURE_PLATE.value(), (Block)FBContent.BLOCK_FRAMED_STONE_PRESSURE_PLATE.value());
            this.dropOtherWithCamo((Block)FBContent.BLOCK_FRAMED_WATERLOGGABLE_OBSIDIAN_PRESSURE_PLATE.value(), (Block)FBContent.BLOCK_FRAMED_OBSIDIAN_PRESSURE_PLATE.value());
            this.dropOtherWithCamo((Block)FBContent.BLOCK_FRAMED_WATERLOGGABLE_GOLD_PRESSURE_PLATE.value(), (Block)FBContent.BLOCK_FRAMED_GOLD_PRESSURE_PLATE.value());
            this.dropOtherWithCamo((Block)FBContent.BLOCK_FRAMED_WATERLOGGABLE_IRON_PRESSURE_PLATE.value(), (Block)FBContent.BLOCK_FRAMED_IRON_PRESSURE_PLATE.value());
            this.dropDoorWithCamo((Block)FBContent.BLOCK_FRAMED_DOOR.value());
            this.dropDoorWithCamo((Block)FBContent.BLOCK_FRAMED_IRON_DOOR.value());
            this.dropMultipleWithCamo((Block)FBContent.BLOCK_FRAMED_DOUBLE_SLAB.value(), (Block)FBContent.BLOCK_FRAMED_SLAB.value(), 2);
            this.dropMultipleWithCamo((Block)FBContent.BLOCK_FRAMED_DOUBLE_PANEL.value(), (Block)FBContent.BLOCK_FRAMED_PANEL.value(), 2);
            this.dropOtherWithCamo((Block)FBContent.BLOCK_FRAMED_VERTICAL_HALF_SLOPE.value(), (Block)FBContent.BLOCK_FRAMED_HALF_SLOPE.value());
            this.dropOtherWithCamo((Block)FBContent.BLOCK_FRAMED_VERTICAL_DOUBLE_HALF_SLOPE.value(), (Block)FBContent.BLOCK_FRAMED_DOUBLE_HALF_SLOPE.value());
            this.dropSelfWithCamo((Block)FBContent.BLOCK_FRAMED_TANK.value(), builder -> builder.apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include((DataComponentType)FBContent.DC_TYPE_TANK_CONTENTS.value())));
            this.add((Block)FBContent.BLOCK_FRAMED_MASONRY_CORNER_SEGMENT.value(), BlockLootTable.noDrop());
            this.add((Block)FBContent.BLOCK_FRAMED_CHECKERED_CUBE_SEGMENT.value(), BlockLootTable.noDrop());
            this.add((Block)FBContent.BLOCK_FRAMED_CHECKERED_SLAB_SEGMENT.value(), BlockLootTable.noDrop());
            this.add((Block)FBContent.BLOCK_FRAMED_CHECKERED_PANEL_SEGMENT.value(), BlockLootTable.noDrop());
            FBContent.getRegisteredBlocks().stream().map(Holder::value).filter(IFramedBlock.class::isInstance).filter(block -> !this.map.containsKey(block.getLootTable())).forEach(x$0 -> this.dropSelfWithCamo((Block)x$0));
            this.dropSelf((Block)FBContent.BLOCK_FRAMING_SAW.value());
            this.dropSelf((Block)FBContent.BLOCK_POWERED_FRAMING_SAW.value());
        }
    }
}

