/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.slopeedge;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CornerType;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.data.property.StairsType;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.QuarterTriangleDir;
import xfacthd.framedblocks.common.data.skippreds.TriangleDir;
import xfacthd.framedblocks.common.data.skippreds.pillar.ThreewayCornerPillarSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.MasonryCornerSegmentSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeedge.CornerSlopeEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeedge.ElevatedInnerCornerSlopeEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeedge.InnerCornerSlopeEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeedge.SlopeEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeedge.ThreewayCornerSlopeEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.ExtendedInnerCornerSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.ExtendedInnerCornerSlopePanelWallSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.LargeCornerSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.LargeCornerSlopePanelWallSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.LargeInnerCornerSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.LargeInnerCornerSlopePanelWallSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.HalfStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.StairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalHalfStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalStairsSkipPredicate;

@CullTest(value={BlockType.FRAMED_INNER_THREEWAY_CORNER_SLOPE_EDGE})
public final class InnerThreewayCornerSlopeEdgeSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.getBlock();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType blockType = (BlockType)object;
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.getValue((Property)FramedProperties.TOP);
            boolean right = (Boolean)state.getValue((Property)PropertyHolder.RIGHT);
            boolean alt = (Boolean)state.getValue((Property)PropertyHolder.ALT_TYPE);
            return switch (blockType) {
                case BlockType.FRAMED_INNER_THREEWAY_CORNER_SLOPE_EDGE -> InnerThreewayCornerSlopeEdgeSkipPredicate.testAgainstInnerThreewayCornerSlopeEdge(dir, top, right, alt, adjState, side);
                case BlockType.FRAMED_THREEWAY_CORNER_SLOPE_EDGE -> InnerThreewayCornerSlopeEdgeSkipPredicate.testAgainstThreewayCornerSlopeEdge(dir, top, right, alt, adjState, side);
                case BlockType.FRAMED_SLOPE_EDGE -> InnerThreewayCornerSlopeEdgeSkipPredicate.testAgainstSlopeEdge(dir, top, right, alt, adjState, side);
                case BlockType.FRAMED_CORNER_SLOPE_EDGE -> InnerThreewayCornerSlopeEdgeSkipPredicate.testAgainstCornerSlopeEdge(dir, top, right, alt, adjState, side);
                case BlockType.FRAMED_INNER_CORNER_SLOPE_EDGE -> InnerThreewayCornerSlopeEdgeSkipPredicate.testAgainstInnerCornerSlopeEdge(dir, top, right, alt, adjState, side);
                case BlockType.FRAMED_ELEVATED_INNER_CORNER_SLOPE_EDGE -> InnerThreewayCornerSlopeEdgeSkipPredicate.testAgainstElevatedInnerCornerSlopeEdge(dir, top, right, alt, adjState, side);
                case BlockType.FRAMED_STAIRS -> InnerThreewayCornerSlopeEdgeSkipPredicate.testAgainstStairs(dir, top, right, alt, adjState, side);
                case BlockType.FRAMED_VERTICAL_STAIRS -> InnerThreewayCornerSlopeEdgeSkipPredicate.testAgainstVerticalStairs(dir, top, right, alt, adjState, side);
                case BlockType.FRAMED_HALF_STAIRS -> InnerThreewayCornerSlopeEdgeSkipPredicate.testAgainstHalfStairs(dir, top, right, alt, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_STAIRS -> InnerThreewayCornerSlopeEdgeSkipPredicate.testAgainstVerticalHalfStairs(dir, top, right, alt, adjState, side);
                case BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL -> InnerThreewayCornerSlopeEdgeSkipPredicate.testAgainstLargeCornerSlopePanel(dir, top, right, alt, adjState, side);
                case BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL_W -> InnerThreewayCornerSlopeEdgeSkipPredicate.testAgainstLargeCornerSlopePanelWall(dir, top, right, alt, adjState, side);
                case BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL -> InnerThreewayCornerSlopeEdgeSkipPredicate.testAgainstLargeInnerCornerSlopePanel(dir, top, right, alt, adjState, side);
                case BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL_W -> InnerThreewayCornerSlopeEdgeSkipPredicate.testAgainstLargeInnerCornerSlopePanelWall(dir, top, right, alt, adjState, side);
                case BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL -> InnerThreewayCornerSlopeEdgeSkipPredicate.testAgainstExtendedInnerCornerSlopePanel(dir, top, right, alt, adjState, side);
                case BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL_W -> InnerThreewayCornerSlopeEdgeSkipPredicate.testAgainstExtendedInnerCornerSlopePanelWall(dir, top, right, alt, adjState, side);
                case BlockType.FRAMED_MASONRY_CORNER_SEGMENT -> InnerThreewayCornerSlopeEdgeSkipPredicate.testAgainstMasonryCornerSegment(dir, top, right, alt, adjState, side);
                case BlockType.FRAMED_THREEWAY_CORNER_PILLAR -> InnerThreewayCornerSlopeEdgeSkipPredicate.testAgainstThreewayCornerPillar(dir, top, right, alt, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_INNER_THREEWAY_CORNER_SLOPE_EDGE})
    private static boolean testAgainstInnerThreewayCornerSlopeEdge(Direction dir, boolean top, boolean right, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.getValue((Property)PropertyHolder.RIGHT);
        boolean adjAlt = (Boolean)adjState.getValue((Property)PropertyHolder.ALT_TYPE);
        return InnerThreewayCornerSlopeEdgeSkipPredicate.getTriDir(dir, top, right, alt, side).isEqualTo(InnerThreewayCornerSlopeEdgeSkipPredicate.getTriDir(adjDir, adjTop, adjRight, adjAlt, side.getOpposite())) || InnerThreewayCornerSlopeEdgeSkipPredicate.getStairDir(dir, top, right, alt, side).isEqualTo(InnerThreewayCornerSlopeEdgeSkipPredicate.getStairDir(adjDir, adjTop, adjRight, adjAlt, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_THREEWAY_CORNER_SLOPE_EDGE})
    private static boolean testAgainstThreewayCornerSlopeEdge(Direction dir, boolean top, boolean right, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.getValue((Property)PropertyHolder.RIGHT);
        boolean adjAlt = (Boolean)adjState.getValue((Property)PropertyHolder.ALT_TYPE);
        return InnerThreewayCornerSlopeEdgeSkipPredicate.getTriDir(dir, top, right, alt, side).isEqualTo(ThreewayCornerSlopeEdgeSkipPredicate.getTriDir(adjDir, adjTop, adjRight, adjAlt, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLOPE_EDGE})
    private static boolean testAgainstSlopeEdge(Direction dir, boolean top, boolean right, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        SlopeType adjType = (SlopeType)((Object)adjState.getValue(PropertyHolder.SLOPE_TYPE));
        boolean adjAlt = (Boolean)adjState.getValue((Property)PropertyHolder.ALT_TYPE);
        return InnerThreewayCornerSlopeEdgeSkipPredicate.getTriDir(dir, top, right, alt, side).isEqualTo(SlopeEdgeSkipPredicate.getTriDir(adjDir, adjType, adjAlt, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_CORNER_SLOPE_EDGE})
    private static boolean testAgainstCornerSlopeEdge(Direction dir, boolean top, boolean right, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.getValue(PropertyHolder.CORNER_TYPE));
        boolean adjAlt = (Boolean)adjState.getValue((Property)PropertyHolder.ALT_TYPE);
        return InnerThreewayCornerSlopeEdgeSkipPredicate.getTriDir(dir, top, right, alt, side).isEqualTo(CornerSlopeEdgeSkipPredicate.getTriDir(adjDir, adjType, adjAlt, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_INNER_CORNER_SLOPE_EDGE})
    private static boolean testAgainstInnerCornerSlopeEdge(Direction dir, boolean top, boolean right, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.getValue(PropertyHolder.CORNER_TYPE));
        boolean adjAlt = (Boolean)adjState.getValue((Property)PropertyHolder.ALT_TYPE);
        return InnerThreewayCornerSlopeEdgeSkipPredicate.getTriDir(dir, top, right, alt, side).isEqualTo(InnerCornerSlopeEdgeSkipPredicate.getTriDir(adjDir, adjType, adjAlt, side.getOpposite())) || InnerThreewayCornerSlopeEdgeSkipPredicate.getStairDir(dir, top, right, alt, side).isEqualTo(InnerCornerSlopeEdgeSkipPredicate.getStairDir(adjDir, adjType, adjAlt, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_INNER_CORNER_SLOPE_EDGE})
    private static boolean testAgainstElevatedInnerCornerSlopeEdge(Direction dir, boolean top, boolean right, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.getValue(PropertyHolder.CORNER_TYPE));
        return InnerThreewayCornerSlopeEdgeSkipPredicate.getStairDir(dir, top, right, alt, side).isEqualTo(ElevatedInnerCornerSlopeEdgeSkipPredicate.getStairDir(adjDir, adjType, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_STAIRS})
    private static boolean testAgainstStairs(Direction dir, boolean top, boolean right, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        StairsShape adjShape = (StairsShape)adjState.getValue((Property)BlockStateProperties.STAIRS_SHAPE);
        Half adjHalf = (Half)adjState.getValue((Property)BlockStateProperties.HALF);
        return InnerThreewayCornerSlopeEdgeSkipPredicate.getStairDir(dir, top, right, alt, side).isEqualTo(StairsSkipPredicate.getStairDir(adjDir, adjShape, adjHalf, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_VERTICAL_STAIRS})
    private static boolean testAgainstVerticalStairs(Direction dir, boolean top, boolean right, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.getValue(PropertyHolder.STAIRS_TYPE));
        return InnerThreewayCornerSlopeEdgeSkipPredicate.getStairDir(dir, top, right, alt, side).isEqualTo(VerticalStairsSkipPredicate.getStairDir(adjDir, adjType, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_HALF_STAIRS})
    private static boolean testAgainstHalfStairs(Direction dir, boolean top, boolean right, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.getValue((Property)PropertyHolder.RIGHT);
        return InnerThreewayCornerSlopeEdgeSkipPredicate.getStairDir(dir, top, right, alt, side).isEqualTo(HalfStairsSkipPredicate.getStairDir(adjDir, adjTop, adjRight, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_VERTICAL_HALF_STAIRS})
    private static boolean testAgainstVerticalHalfStairs(Direction dir, boolean top, boolean right, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return InnerThreewayCornerSlopeEdgeSkipPredicate.getStairDir(dir, top, right, alt, side).isEqualTo(VerticalHalfStairsSkipPredicate.getStairDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL})
    private static boolean testAgainstLargeCornerSlopePanel(Direction dir, boolean top, boolean right, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return InnerThreewayCornerSlopeEdgeSkipPredicate.getStairDir(dir, top, right, alt, side).isEqualTo(LargeCornerSlopePanelSkipPredicate.getStairDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstLargeCornerSlopePanelWall(Direction dir, boolean top, boolean right, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return InnerThreewayCornerSlopeEdgeSkipPredicate.getStairDir(dir, top, right, alt, side).isEqualTo(LargeCornerSlopePanelWallSkipPredicate.getStairDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL})
    private static boolean testAgainstLargeInnerCornerSlopePanel(Direction dir, boolean top, boolean right, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return InnerThreewayCornerSlopeEdgeSkipPredicate.getStairDir(dir, top, right, alt, side).isEqualTo(LargeInnerCornerSlopePanelSkipPredicate.getStairDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstLargeInnerCornerSlopePanelWall(Direction dir, boolean top, boolean right, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return InnerThreewayCornerSlopeEdgeSkipPredicate.getStairDir(dir, top, right, alt, side).isEqualTo(LargeInnerCornerSlopePanelWallSkipPredicate.getStairDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL})
    private static boolean testAgainstExtendedInnerCornerSlopePanel(Direction dir, boolean top, boolean right, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return InnerThreewayCornerSlopeEdgeSkipPredicate.getStairDir(dir, top, right, alt, side).isEqualTo(ExtendedInnerCornerSlopePanelSkipPredicate.getStairDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstExtendedInnerCornerSlopePanelWall(Direction dir, boolean top, boolean right, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return InnerThreewayCornerSlopeEdgeSkipPredicate.getStairDir(dir, top, right, alt, side).isEqualTo(ExtendedInnerCornerSlopePanelWallSkipPredicate.getStairDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_MASONRY_CORNER_SEGMENT})
    private static boolean testAgainstMasonryCornerSegment(Direction dir, boolean top, boolean right, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return InnerThreewayCornerSlopeEdgeSkipPredicate.getStairDir(dir, top, right, alt, side).isEqualTo(MasonryCornerSegmentSkipPredicate.getStairDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_THREEWAY_CORNER_PILLAR})
    private static boolean testAgainstThreewayCornerPillar(Direction dir, boolean top, boolean right, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return InnerThreewayCornerSlopeEdgeSkipPredicate.getStairDir(dir, top, right, alt, side).isEqualTo(ThreewayCornerPillarSkipPredicate.getStairDir(adjDir, adjTop, side.getOpposite()));
    }

    public static QuarterTriangleDir getTriDir(Direction dir, boolean top, boolean right, boolean alt, Direction side) {
        Direction dirTwo;
        Direction bottom = top ? Direction.UP : Direction.DOWN;
        Direction direction = dirTwo = right ? dir.getClockWise() : dir.getCounterClockWise();
        if (side == dir.getOpposite()) {
            return QuarterTriangleDir.fromDirections(bottom, dirTwo, alt);
        }
        if (side == dirTwo.getOpposite()) {
            return QuarterTriangleDir.fromDirections(bottom, dir, alt);
        }
        if (side == bottom.getOpposite()) {
            return QuarterTriangleDir.fromDirections(dir, dirTwo, alt);
        }
        return QuarterTriangleDir.NULL;
    }

    public static TriangleDir getStairDir(Direction dir, boolean top, boolean right, boolean alt, Direction side) {
        if (!alt) {
            Direction dirTwo;
            Direction bottom = top ? Direction.UP : Direction.DOWN;
            Direction direction = dirTwo = right ? dir.getClockWise() : dir.getCounterClockWise();
            if (side == dir) {
                return TriangleDir.fromDirections(bottom, dirTwo);
            }
            if (side == dirTwo) {
                return TriangleDir.fromDirections(bottom, dir);
            }
            if (side == bottom) {
                return TriangleDir.fromDirections(dir, dirTwo);
            }
        }
        return TriangleDir.NULL;
    }
}

