/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.pillar;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.skippreds.CullTest;

@CullTest(value={BlockType.FRAMED_WALL})
public final class WallSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.getBlock();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            boolean up = (Boolean)state.getValue((Property)WallBlock.UP);
            return switch (type) {
                case BlockType.FRAMED_WALL -> WallSkipPredicate.testAgainstWall(state, up, adjState, side);
                case BlockType.FRAMED_PILLAR -> WallSkipPredicate.testAgainstPillar(up, adjState, side);
                case BlockType.FRAMED_HALF_PILLAR -> WallSkipPredicate.testAgainstHalfPillar(up, adjState, side);
                case BlockType.FRAMED_THICK_LATTICE -> WallSkipPredicate.testAgainstThickLattice(up, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_WALL})
    private static boolean testAgainstWall(BlockState state, boolean up, BlockState adjState, Direction side) {
        if (Utils.isY(side)) {
            boolean adjUp = (Boolean)adjState.getValue((Property)WallBlock.UP);
            return up == adjUp;
        }
        return WallSkipPredicate.getArm(state, side) == WallSkipPredicate.getArm(adjState, side.getOpposite());
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_PILLAR})
    private static boolean testAgainstPillar(boolean up, BlockState adjState, Direction side) {
        return Utils.isY(side) && up && adjState.getValue((Property)BlockStateProperties.AXIS) == Direction.Axis.Y;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_HALF_PILLAR})
    private static boolean testAgainstHalfPillar(boolean up, BlockState adjState, Direction side) {
        return Utils.isY(side) && up && adjState.getValue((Property)BlockStateProperties.FACING) == side.getOpposite();
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_THICK_LATTICE})
    private static boolean testAgainstThickLattice(boolean up, BlockState adjState, Direction side) {
        return Utils.isY(side) && up && (Boolean)adjState.getValue((Property)FramedProperties.Y_AXIS) != false;
    }

    public static WallSide getArm(BlockState state, Direction dir) {
        return switch (dir) {
            case Direction.NORTH -> (WallSide)state.getValue((Property)WallBlock.NORTH_WALL);
            case Direction.EAST -> (WallSide)state.getValue((Property)WallBlock.EAST_WALL);
            case Direction.SOUTH -> (WallSide)state.getValue((Property)WallBlock.SOUTH_WALL);
            case Direction.WEST -> (WallSide)state.getValue((Property)WallBlock.WEST_WALL);
            default -> throw new IllegalArgumentException("Invalid wall arm direction");
        };
    }
}

