/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.shapes.stairs.standard;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.common.data.PropertyHolder;

public final class HalfStairsShapes {
    public static ShapeProvider generate(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape bottomLeft = ShapeUtils.orUnoptimized(Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.box((double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0));
        VoxelShape bottomRight = ShapeUtils.orUnoptimized(Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)16.0), Block.box((double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0));
        VoxelShape topLeft = ShapeUtils.orUnoptimized(Block.box((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0));
        VoxelShape topRight = ShapeUtils.orUnoptimized(Block.box((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0));
        int maskTop = 4;
        int maskRight = 8;
        VoxelShape[] shapes = new VoxelShape[16];
        ShapeUtils.makeHorizontalRotations(bottomLeft, Direction.SOUTH, shapes, 0);
        ShapeUtils.makeHorizontalRotations(bottomRight, Direction.SOUTH, shapes, maskRight);
        ShapeUtils.makeHorizontalRotations(topLeft, Direction.SOUTH, shapes, maskTop);
        ShapeUtils.makeHorizontalRotations(topRight, Direction.SOUTH, shapes, maskTop | maskRight);
        for (BlockState state : states) {
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            int top = (Boolean)state.getValue((Property)FramedProperties.TOP) != false ? maskTop : 0;
            int right = (Boolean)state.getValue((Property)PropertyHolder.RIGHT) != false ? maskRight : 0;
            builder.put((Object)state, (Object)shapes[dir.get2DDataValue() | top | right]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    private HalfStairsShapes() {
    }
}

