/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.shapes.slope;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.common.data.shapes.SplitShapeGenerator;

public final class PyramidShapes
implements SplitShapeGenerator {
    public static final PyramidShapes FULL = new PyramidShapes(() -> ShapeUtils.orUnoptimized(Block.box((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)8.0)), () -> ShapeUtils.orUnoptimized(Block.box((double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.25, (double)0.25, (double)8.0, (double)15.75, (double)15.75, (double)16.0), Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)8.0)));
    public static final PyramidShapes SLAB = new PyramidShapes(() -> ShapeUtils.orUnoptimized(Block.box((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0, (double)12.0)), () -> ShapeUtils.orUnoptimized(Block.box((double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.5, (double)0.5, (double)12.0, (double)15.5, (double)15.5, (double)16.0), Block.box((double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0, (double)12.0)));
    private final Supplier<VoxelShape> northShape;
    private final Supplier<VoxelShape> northOcclusionShape;

    private PyramidShapes(Supplier<VoxelShape> northShape, Supplier<VoxelShape> northOcclusionShape) {
        this.northShape = northShape;
        this.northOcclusionShape = northOcclusionShape;
    }

    @Override
    public ShapeProvider generate(ImmutableList<BlockState> states) {
        return PyramidShapes.generate(states, this.northShape);
    }

    @Override
    public ShapeProvider generateOcclusionShapes(ImmutableList<BlockState> states) {
        return PyramidShapes.generate(states, this.northOcclusionShape);
    }

    private static ShapeProvider generate(ImmutableList<BlockState> states, Supplier<VoxelShape> northShape) {
        VoxelShape shapeNorth = northShape.get();
        VoxelShape shapeUp = ShapeUtils.rotateShapeAroundX(Direction.NORTH, Direction.UP, shapeNorth);
        VoxelShape shapeDown = ShapeUtils.rotateShapeAroundX(Direction.NORTH, Direction.DOWN, shapeNorth);
        VoxelShape[] horShapes = ShapeUtils.makeHorizontalRotations(shapeNorth, Direction.NORTH);
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction facing = (Direction)state.getValue((Property)BlockStateProperties.FACING);
            VoxelShape shape = switch (facing) {
                case Direction.UP -> shapeUp;
                case Direction.DOWN -> shapeDown;
                default -> horShapes[facing.get2DDataValue()];
            };
            builder.put((Object)state, (Object)shape);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

