/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.doubleblock;

import java.util.Arrays;
import java.util.Objects;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.cache.StateCache;
import xfacthd.framedblocks.api.type.IBlockType;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.IFramedDoubleBlock;
import xfacthd.framedblocks.common.data.doubleblock.CamoGetter;
import xfacthd.framedblocks.common.data.doubleblock.DoubleBlockTopInteractionMode;
import xfacthd.framedblocks.common.data.doubleblock.SolidityCheck;

public class DoubleBlockStateCache
extends StateCache {
    private final DoubleBlockTopInteractionMode topInteractionMode;
    private final Tuple<BlockState, BlockState> statePair;
    private final SolidityCheck[] solidityChecks = new SolidityCheck[DIR_COUNT];
    private final CamoGetter[] camoGetters = new CamoGetter[DIR_COUNT * DIR_COUNT_N];

    public DoubleBlockStateCache(BlockState state, IBlockType type) {
        super(state, type);
        IFramedDoubleBlock block = (IFramedDoubleBlock)state.getBlock();
        this.topInteractionMode = block.calculateTopInteractionMode(state);
        this.statePair = block.calculateBlockPair(state);
        Utils.forAllDirections(false, side -> {
            this.solidityChecks[side.ordinal()] = block.calculateSolidityCheck(state, (Direction)side);
            Utils.forAllDirections(edge -> {
                CamoGetter getter;
                if (edge != null && edge.getAxis() == side.getAxis()) {
                    int cgNullIdx = side.ordinal() * DIR_COUNT_N + Utils.maskNullDirection(null);
                    getter = this.camoGetters[cgNullIdx];
                } else {
                    getter = block.calculateCamoGetter(state, (Direction)side, (Direction)edge);
                }
                int cgIdx = side.ordinal() * DIR_COUNT_N + Utils.maskNullDirection(edge);
                this.camoGetters[cgIdx] = getter;
            });
        });
    }

    public final DoubleBlockTopInteractionMode getTopInteractionMode() {
        return this.topInteractionMode;
    }

    public final Tuple<BlockState, BlockState> getBlockPair() {
        return this.statePair;
    }

    public final SolidityCheck getSolidityCheck(Direction side) {
        return this.solidityChecks[side.ordinal()];
    }

    public final CamoGetter getCamoGetter(Direction side, @Nullable Direction edge) {
        return this.camoGetters[side.ordinal() * DIR_COUNT_N + Utils.maskNullDirection(edge)];
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        DoubleBlockStateCache that = (DoubleBlockStateCache)other;
        return this.topInteractionMode == that.topInteractionMode && this.statePair.getA() == that.statePair.getA() && this.statePair.getB() == that.statePair.getB() && Arrays.equals((Object[])this.solidityChecks, (Object[])that.solidityChecks) && Arrays.equals((Object[])this.camoGetters, (Object[])that.camoGetters);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode((Object)this.topInteractionMode);
        result = 31 * result + Objects.hashCode(this.statePair.getA());
        result = 31 * result + Objects.hashCode(this.statePair.getB());
        result = 31 * result + Arrays.hashCode((Object[])this.solidityChecks);
        result = 31 * result + Arrays.hashCode((Object[])this.camoGetters);
        return result;
    }
}

