/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.conpreds.stairs;

import net.minecraft.core.Direction;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.predicate.contex.NonDetailedConnectionPredicate;
import xfacthd.framedblocks.api.util.Utils;

public final class DoubleStairsConnectionPredicate
extends NonDetailedConnectionPredicate {
    @Override
    public boolean canConnectFullEdge(BlockState state, Direction side, @Nullable Direction edge) {
        Direction facing = (Direction)state.getValue((Property)StairBlock.FACING);
        StairsShape shape = (StairsShape)state.getValue((Property)StairBlock.SHAPE);
        boolean top = state.getValue((Property)StairBlock.HALF) == Half.TOP;
        Direction dirTwo = top ? Direction.UP : Direction.DOWN;
        return switch (shape) {
            default -> throw new MatchException(null, null);
            case StairsShape.STRAIGHT -> {
                if (side == facing || side == dirTwo) {
                    yield true;
                }
                if (side.getAxis() == facing.getClockWise().getAxis()) {
                    if (edge == facing || edge == dirTwo) {
                        yield true;
                    }
                    yield false;
                }
                if (side == dirTwo.getOpposite()) {
                    if (edge != null && edge.getAxis() == facing.getAxis()) {
                        yield true;
                    }
                    yield false;
                }
                if (side == facing.getOpposite()) {
                    if (edge != null && Utils.isY(edge)) {
                        yield true;
                    }
                    yield false;
                }
                yield false;
            }
            case StairsShape.INNER_LEFT -> {
                if (side == facing || side == facing.getCounterClockWise() || side == dirTwo) {
                    yield true;
                }
                if (side == facing.getClockWise()) {
                    if (edge == facing || edge == dirTwo) {
                        yield true;
                    }
                    yield false;
                }
                if (side == facing.getOpposite()) {
                    if (edge == facing.getCounterClockWise() || edge == dirTwo) {
                        yield true;
                    }
                    yield false;
                }
                if (side == dirTwo.getOpposite()) {
                    if (edge == facing || edge == facing.getCounterClockWise()) {
                        yield true;
                    }
                    yield false;
                }
                yield false;
            }
            case StairsShape.INNER_RIGHT -> {
                if (side == facing || side == facing.getClockWise() || side == dirTwo) {
                    yield true;
                }
                if (side == facing.getCounterClockWise()) {
                    if (edge == facing || edge == dirTwo) {
                        yield true;
                    }
                    yield false;
                }
                if (side == facing.getOpposite()) {
                    if (edge == facing.getClockWise() || edge == dirTwo) {
                        yield true;
                    }
                    yield false;
                }
                if (side == dirTwo.getOpposite()) {
                    if (edge == facing || edge == facing.getClockWise()) {
                        yield true;
                    }
                    yield false;
                }
                yield false;
            }
            case StairsShape.OUTER_LEFT -> {
                if (side == dirTwo) {
                    yield true;
                }
                if (side == dirTwo.getOpposite()) {
                    if (edge == facing.getClockWise() || edge == facing.getOpposite()) {
                        yield true;
                    }
                    yield false;
                }
                if (side == facing) {
                    if (edge == facing.getCounterClockWise() || edge == dirTwo) {
                        yield true;
                    }
                    yield false;
                }
                if (side == facing.getCounterClockWise()) {
                    if (edge == facing || edge == dirTwo) {
                        yield true;
                    }
                    yield false;
                }
                if (side == facing.getClockWise() || side == facing.getOpposite()) {
                    if (edge != null && Utils.isY(edge)) {
                        yield true;
                    }
                    yield false;
                }
                yield false;
            }
            case StairsShape.OUTER_RIGHT -> {
                if (side == dirTwo) {
                    yield true;
                }
                if (side == dirTwo.getOpposite()) {
                    if (edge == facing.getCounterClockWise() || edge == facing.getOpposite()) {
                        yield true;
                    }
                    yield false;
                }
                if (side == facing) {
                    if (edge == facing.getClockWise() || edge == dirTwo) {
                        yield true;
                    }
                    yield false;
                }
                if (side == facing.getClockWise()) {
                    if (edge == facing || edge == dirTwo) {
                        yield true;
                    }
                    yield false;
                }
                if (side == facing.getCounterClockWise() || side == facing.getOpposite()) {
                    if (edge != null && Utils.isY(edge)) {
                        yield true;
                    }
                    yield false;
                }
                yield false;
            }
        };
    }
}

