/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.crafting;

import java.util.Objects;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.common.crafting.ShapeRotationRecipe;
import xfacthd.framedblocks.common.datagen.builders.recipe.ExtShapelessRecipeBuilder;

public final class ShapeRotationRecipeBuilder
extends ExtShapelessRecipeBuilder {
    @Nullable
    private Ingredient tool = null;
    @Nullable
    private Ingredient block = null;

    public ShapeRotationRecipeBuilder(ItemLike result) {
        super(RecipeCategory.BUILDING_BLOCKS, result, 1);
    }

    public ShapeRotationRecipeBuilder tool(Ingredient tool) {
        this.tool = tool;
        return this;
    }

    public ShapeRotationRecipeBuilder block(ItemLike block) {
        this.block = Ingredient.of((ItemLike[])new ItemLike[]{block});
        return this;
    }

    @Override
    public ShapeRotationRecipeBuilder requires(TagKey<Item> pTag) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ShapeRotationRecipeBuilder requires(ItemLike pItem) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ShapeRotationRecipeBuilder requires(ItemLike pItem, int pQuantity) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ShapeRotationRecipeBuilder requires(Ingredient pIngredient) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ShapeRotationRecipeBuilder requires(Ingredient pIngredient, int pQuantity) {
        throw new UnsupportedOperationException();
    }

    public void save(RecipeOutput output, ResourceLocation key) {
        Advancement.Builder advancement = output.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)key)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)key)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancement).addCriterion(arg_0, arg_1));
        String recipeGroup = Objects.requireNonNullElse(this.group, "");
        ShapeRotationRecipe recipe = new ShapeRotationRecipe(recipeGroup, this.result.getDefaultInstance(), this.tool, this.block);
        output.accept(key, (Recipe)recipe, advancement.build(key.withPrefix("recipes/" + this.category.getFolderName() + "/")));
    }
}

