/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.crafting;

import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.crafting.FramingSawRecipe;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeAdditive;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeCache;

public final class FramingSawRecipeCalculation {
    private final FramingSawRecipe recipe;
    private final int inputValue;
    private final long lcm;

    FramingSawRecipeCalculation(FramingSawRecipe recipe, RecipeInput container, boolean client) {
        this.recipe = recipe;
        this.inputValue = FramingSawRecipeCalculation.getInputValue(container.getItem(0), client);
        this.lcm = FramingSawRecipeCalculation.getMaterialLCM(recipe, this.inputValue);
    }

    public int getInputCount() {
        return (int)(this.lcm / (long)this.inputValue);
    }

    public int getOutputCount() {
        return FramingSawRecipeCalculation.getOutputCount(this.recipe.getMaterialAmount(), this.recipe.getResult(), this.lcm);
    }

    public int getAdditiveCount(int idx) {
        return FramingSawRecipeCalculation.getAdditiveCount(this.recipe, this.recipe.getAdditives().get(idx), this.lcm);
    }

    static int getInputValue(ItemStack input, boolean client) {
        FramingSawRecipeCache cache = FramingSawRecipeCache.get(client);
        return cache.getMaterialValue(input.getItem());
    }

    static long getMaterialLCM(FramingSawRecipe recipe, int inputValue) {
        return Utils.lcm(inputValue, recipe.getMaterialAmount());
    }

    static int getOutputCount(int materialAmount, ItemStack result, long lcm) {
        return (int)(lcm / (long)materialAmount * (long)result.getCount());
    }

    static int getAdditiveCount(FramingSawRecipe recipe, FramingSawRecipeAdditive additive, long lcm) {
        return (int)(lcm / (long)recipe.getMaterialAmount()) * additive.count();
    }
}

