/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.compat.ae2;

import appeng.api.crafting.IPatternDetails;
import appeng.api.implementations.blockentities.ICraftingMachine;
import appeng.api.implementations.blockentities.PatternContainerGroup;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import com.google.common.primitives.Ints;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.common.util.Lazy;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.blockentity.special.PoweredFramingSawBlockEntity;
import xfacthd.framedblocks.common.capability.RecipeInputItemStackHandler;
import xfacthd.framedblocks.common.compat.ae2.FramingSawPatternDetails;

final class FramingSawCraftingMachine
implements ICraftingMachine {
    private static final Lazy<PatternContainerGroup> GROUP = Lazy.of(() -> new PatternContainerGroup(AEItemKey.of((ItemLike)((ItemLike)FBContent.BLOCK_POWERED_FRAMING_SAW.value())), ((Block)FBContent.BLOCK_POWERED_FRAMING_SAW.value()).asItem().getDescription(), List.of()));
    private final PoweredFramingSawBlockEntity blockEntity;

    FramingSawCraftingMachine(IAttachmentHolder blockEntity) {
        this.blockEntity = (PoweredFramingSawBlockEntity)blockEntity;
    }

    public PatternContainerGroup getCraftingMachineInfo() {
        return (PatternContainerGroup)GROUP.get();
    }

    public boolean pushPattern(IPatternDetails pattern, KeyCounter[] inputs, Direction ejectDir) {
        if (pattern instanceof FramingSawPatternDetails) {
            int i;
            FramingSawPatternDetails sawPattern = (FramingSawPatternDetails)pattern;
            if (!this.blockEntity.isInputEmpty() && !sawPattern.getRecipe().equals(this.blockEntity.getSelectedRecipe())) {
                return false;
            }
            RecipeInputItemStackHandler inv = this.blockEntity.getItemHandler();
            for (i = 0; i < 4; ++i) {
                ItemStack stack = inv.getStackInSlot(i);
                if (i >= inputs.length) {
                    if (stack.isEmpty()) continue;
                    return false;
                }
                Object2LongMap.Entry entry = inputs[i].getFirstEntry();
                if (entry == null) continue;
                Object object = entry.getKey();
                if (!(object instanceof AEItemKey)) {
                    return false;
                }
                AEItemKey itemKey = (AEItemKey)object;
                if (stack.isEmpty() || itemKey.matches(stack) && (long)stack.getCount() + entry.getLongValue() <= (long)stack.getMaxStackSize()) continue;
                return false;
            }
            this.blockEntity.selectRecipe(sawPattern.getRecipe());
            for (i = 0; i < inputs.length; ++i) {
                Object2LongMap.Entry entry = inputs[i].getFirstEntry();
                if (entry == null) continue;
                int count = Ints.saturatedCast((long)entry.getLongValue());
                inv.insertItem(i, ((AEItemKey)entry.getKey()).toStack(count), false);
                inputs[i].remove((AEKey)entry.getKey(), (long)count);
            }
            return true;
        }
        return false;
    }

    public boolean acceptsPlans() {
        return true;
    }
}

