/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity.special;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.capability.EntityAwareEnergyStorage;
import xfacthd.framedblocks.common.capability.ExternalItemHandler;
import xfacthd.framedblocks.common.capability.RecipeInputItemStackHandler;
import xfacthd.framedblocks.common.config.ServerConfig;
import xfacthd.framedblocks.common.crafting.FramingSawRecipe;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeAdditive;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeCache;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeCalculation;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeMatchResult;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class PoweredFramingSawBlockEntity
extends BlockEntity {
    private static final boolean INSERT_ENERGY_DEBUG = true;
    private static final long ACTIVE_TIMEOUT = 40L;
    private final RecipeInputItemStackHandler itemHandler = new RecipeInputItemStackHandler(5){

        protected void onContentsChanged(int slot) {
            PoweredFramingSawBlockEntity.this.onContentsChanged(slot);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return PoweredFramingSawBlockEntity.this.isValidItem(slot, stack);
        }
    };
    private final IItemHandler externalItemHandler = new ExternalItemHandler(this, (IItemHandler)this.itemHandler){

        @Override
        protected boolean canExtract(int slot) {
            return slot == 4;
        }
    };
    private final EntityAwareEnergyStorage energyStorage = new EntityAwareEnergyStorage(ServerConfig.VIEW.getPoweredSawEnergyCapacity(), ServerConfig.VIEW.getPoweredSawMaxInput(), 0, () -> {
        this.needSaving = true;
    });
    private final int energyConsumption = ServerConfig.VIEW.getPoweredSawConsumption();
    private final int craftingDuration = ServerConfig.VIEW.getPoweredSawCraftingDuration();
    private FramingSawRecipeCache cache = null;
    private ResourceLocation selectedRecipeId = null;
    private RecipeHolder<FramingSawRecipe> selectedRecipe = null;
    private boolean active = false;
    private long lastActive = 0L;
    private boolean recipeSatisfied = false;
    private FramingSawRecipeMatchResult matchResult = null;
    private FramingSawRecipeCalculation calculation = null;
    private int outputCount = 0;
    private int progress = 0;
    private boolean needSaving = false;
    private boolean inhibitUpdate = false;
    private boolean internalAccess = false;

    public PoweredFramingSawBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)FBContent.BE_TYPE_POWERED_FRAMING_SAW.value(), pPos, pBlockState);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, PoweredFramingSawBlockEntity be) {
        if (!FMLEnvironment.production) {
            be.energyStorage.receiveEnergy(be.energyStorage.getMaxReceive(), false);
        }
        if ((be.active || level.getGameTime() - be.lastActive > 40L) && be.canRun()) {
            if (!be.active) {
                be.active = true;
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)PropertyHolder.ACTIVE, (Comparable)Boolean.valueOf(true)));
            }
            be.energyStorage.extractEnergyInternal(be.energyConsumption);
            ++be.progress;
            if (be.progress >= be.craftingDuration) {
                be.progress = 0;
                ItemStack result = ((FramingSawRecipe)be.selectedRecipe.value()).getResult().copy();
                result.setCount(be.outputCount);
                be.internalAccess = true;
                be.inhibitUpdate = true;
                for (int i = 0; i < ((FramingSawRecipe)be.selectedRecipe.value()).getAdditives().size(); ++i) {
                    int slot = i + 1;
                    be.itemHandler.extractItem(slot, be.calculation.getAdditiveCount(i), false);
                }
                be.inhibitUpdate = false;
                be.itemHandler.extractItem(0, be.calculation.getInputCount(), false);
                be.itemHandler.insertItem(4, result, false);
                be.internalAccess = false;
            }
        } else if (be.active) {
            be.active = false;
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)PropertyHolder.ACTIVE, (Comparable)Boolean.valueOf(false)));
            be.lastActive = level.getGameTime();
            if (!be.recipeSatisfied) {
                be.progress = 0;
            }
        }
        if (be.needSaving) {
            level.blockEntityChanged(be.worldPosition);
            be.needSaving = false;
        }
    }

    private boolean canRun() {
        if (this.selectedRecipe == null || !this.recipeSatisfied) {
            return false;
        }
        if (this.energyStorage.getEnergyStored() < this.energyConsumption) {
            return false;
        }
        ItemStack output = this.itemHandler.getStackInSlot(4);
        if (!output.isEmpty()) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)output, (ItemStack)((FramingSawRecipe)this.selectedRecipe.value()).getResult())) {
                return false;
            }
            if (output.getCount() + this.outputCount > output.getMaxStackSize()) {
                return false;
            }
        }
        return true;
    }

    private void checkRecipeSatisfied() {
        if (this.selectedRecipe != null) {
            this.matchResult = ((FramingSawRecipe)this.selectedRecipe.value()).matchWithResult(this.itemHandler, this.level());
            this.recipeSatisfied = this.matchResult.success();
        } else {
            this.matchResult = null;
            this.recipeSatisfied = false;
        }
        if (this.recipeSatisfied) {
            this.calculation = ((FramingSawRecipe)this.selectedRecipe.value()).makeCraftingCalculation(this.itemHandler, false);
            this.outputCount = this.calculation.getOutputCount();
        } else {
            this.calculation = null;
            this.outputCount = 0;
            this.progress = 0;
        }
    }

    private void onContentsChanged(int slot) {
        this.needSaving = true;
        if (slot != 4 && !this.inhibitUpdate) {
            this.checkRecipeSatisfied();
        }
    }

    private boolean isValidItem(int slot, ItemStack stack) {
        if (slot == 0) {
            return this.cache.getMaterialValue(stack.getItem()) > 0;
        }
        if (slot < 4) {
            if (this.selectedRecipe != null) {
                int idx = slot - 1;
                List<FramingSawRecipeAdditive> additives = ((FramingSawRecipe)this.selectedRecipe.value()).getAdditives();
                if (!additives.isEmpty() && idx < additives.size()) {
                    return additives.get(idx).ingredient().test(stack);
                }
                return false;
            }
            return true;
        }
        if (slot == 4) {
            return this.internalAccess;
        }
        throw new IllegalArgumentException("Invalid slot: " + slot);
    }

    public void selectRecipe(RecipeHolder<FramingSawRecipe> recipe) {
        ResourceLocation lastId = this.selectedRecipeId;
        this.selectedRecipe = recipe;
        this.selectedRecipeId = recipe == null ? null : recipe.id();
        this.checkRecipeSatisfied();
        if (!Objects.equals(lastId, this.selectedRecipeId)) {
            this.needSaving = true;
        }
    }

    public RecipeHolder<FramingSawRecipe> getSelectedRecipe() {
        return this.selectedRecipe;
    }

    public FramingSawRecipeMatchResult getMatchResult() {
        return this.matchResult;
    }

    public int getProgress() {
        return this.progress;
    }

    public RecipeInputItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public IItemHandler getExternalItemHandler() {
        return this.externalItemHandler;
    }

    public IEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public int getEnergy() {
        return this.energyStorage.getEnergyStored();
    }

    public int getEnergyCapacity() {
        return this.energyStorage.getCapacity();
    }

    public int getCraftingDuration() {
        return this.craftingDuration;
    }

    public void dropContents(Consumer<ItemStack> dropper) {
        this.inhibitUpdate = true;
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            dropper.accept(this.itemHandler.getStackInSlot(i));
            this.itemHandler.setStackInSlot(i, ItemStack.EMPTY);
        }
        this.inhibitUpdate = false;
    }

    public boolean isInputEmpty() {
        for (int i = 0; i < 4; ++i) {
            if (this.itemHandler.getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void onLoad() {
        super.onLoad();
        this.cache = FramingSawRecipeCache.get(this.level().isClientSide());
        if (this.selectedRecipeId != null && !this.level().isClientSide()) {
            RecipeHolder recipe = this.level().getRecipeManager().byKey(this.selectedRecipeId).filter(h -> h.value() instanceof FramingSawRecipe).orElse(null);
            this.selectRecipe((RecipeHolder<FramingSawRecipe>)recipe);
        }
    }

    private Level level() {
        return Objects.requireNonNull(this.level, "BlockEntity#level accessed before it was set");
    }

    public boolean isUsableByPlayer(Player player) {
        if (this.level().getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return !(player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) > 64.0);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (this.selectedRecipe != null) {
            tag.putString("recipe", this.selectedRecipe.id().toString());
        }
        tag.put("inventory", (Tag)this.itemHandler.serializeNBT(provider));
        tag.put("energy", this.energyStorage.serializeNBT(provider));
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains("recipe")) {
            this.selectedRecipeId = ResourceLocation.tryParse((String)tag.getString("recipe"));
        }
        this.itemHandler.deserializeNBT(provider, tag.getCompound("inventory"));
        this.energyStorage.deserializeNBT(provider, (Tag)tag.getCompound("energy"));
    }
}

