/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity.special;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import xfacthd.framedblocks.api.block.blockentity.FramedBlockEntity;
import xfacthd.framedblocks.common.FBContent;

public class FramedOwnableBlockEntity
extends FramedBlockEntity {
    private UUID owner;

    protected FramedOwnableBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public FramedOwnableBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)FBContent.BE_TYPE_FRAMED_OWNABLE_BLOCK.value(), pos, state);
    }

    public void setOwner(UUID owner, boolean forceSync) {
        this.owner = owner;
        this.setChangedWithoutSignalUpdate();
        if (forceSync) {
            this.level().sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public UUID getOwner() {
        return this.owner;
    }

    @Override
    protected void writeToDataPacket(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
        super.writeToDataPacket(nbt, lookupProvider);
        if (this.owner != null) {
            nbt.put("owner", (Tag)NbtUtils.createUUID((UUID)this.owner));
        }
    }

    @Override
    protected boolean readFromDataPacket(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
        if (nbt.contains("owner")) {
            this.owner = NbtUtils.loadUUID((Tag)nbt.get("owner"));
        }
        return super.readFromDataPacket(nbt, lookupProvider);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        if (this.owner != null) {
            tag.putUUID("owner", this.owner);
        }
        return tag;
    }

    @Override
    public void handleUpdateTag(CompoundTag nbt, HolderLookup.Provider provider) {
        super.handleUpdateTag(nbt, provider);
        if (nbt.contains("owner")) {
            this.owner = nbt.getUUID("owner");
        }
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (this.owner != null) {
            tag.putUUID("owner", this.owner);
        }
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains("owner")) {
            this.owner = tag.getUUID("owner");
        }
    }
}

