/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity.special;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.cube.FramedChestBlock;
import xfacthd.framedblocks.common.blockentity.special.FramedStorageBlockEntity;
import xfacthd.framedblocks.common.capability.IStorageBlockItemHandler;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.ChestState;

public class FramedChestBlockEntity
extends FramedStorageBlockEntity {
    public static final Component TITLE = Utils.translate("title", "framed_chest");
    private int openCount = 0;
    private long closeStart = 0L;
    private long lastChangeTime = 0L;
    private ChestState lastState = ChestState.CLOSED;

    public FramedChestBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FBContent.BE_TYPE_FRAMED_CHEST.value(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, FramedChestBlockEntity tile) {
        if (!level.isClientSide() && level.getGameTime() - tile.closeStart >= 10L && state.getValue(PropertyHolder.CHEST_STATE) == ChestState.CLOSING) {
            tile.closeStart = 0L;
            level.setBlockAndUpdate(pos, (BlockState)state.setValue(PropertyHolder.CHEST_STATE, (Comparable)((Object)ChestState.CLOSED)));
        }
    }

    @Override
    public void open(ServerPlayer player) {
        IStorageBlockItemHandler handler = this.getChestItemHandler(false);
        if (handler != null) {
            handler.open();
            super.open(player);
        }
    }

    public void doOpen() {
        ++this.openCount;
        if (this.getBlockState().getValue(PropertyHolder.CHEST_STATE) != ChestState.OPENING) {
            this.level().setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue(PropertyHolder.CHEST_STATE, (Comparable)((Object)ChestState.OPENING)));
            FramedChestBlockEntity.playSound(this.level(), this.worldPosition, this.getBlockState(), SoundEvents.CHEST_OPEN);
        }
    }

    public void close() {
        if (this.openCount > 0) {
            --this.openCount;
            if (this.openCount == 0) {
                FramedChestBlockEntity.playSound(this.level(), this.worldPosition, this.getBlockState(), SoundEvents.CHEST_CLOSE);
                this.level().setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue(PropertyHolder.CHEST_STATE, (Comparable)((Object)ChestState.CLOSING)));
                this.closeStart = this.level().getGameTime();
            }
        }
    }

    private static void playSound(Level level, BlockPos pos, BlockState state, SoundEvent sound) {
        ChestType type = (ChestType)state.getValue((Property)BlockStateProperties.CHEST_TYPE);
        if (type != ChestType.LEFT) {
            double x = (double)pos.getX() + 0.5;
            double y = (double)pos.getY() + 0.5;
            double z = (double)pos.getZ() + 0.5;
            if (type == ChestType.RIGHT) {
                Direction side = FramedChestBlock.getConnectionDirection(state);
                x += (double)side.getStepX() * 0.5;
                z += (double)side.getStepZ() * 0.5;
            }
            level.playSound(null, x, y, z, sound, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
        }
    }

    public long getLastChangeTime(ChestState state) {
        if (this.lastChangeTime == 0L || state != this.lastState) {
            if (this.lastState == ChestState.CLOSING && state == ChestState.OPENING || this.lastState == ChestState.OPENING && state == ChestState.CLOSING) {
                long diff = this.level().getGameTime() - this.lastChangeTime;
                this.lastChangeTime = this.level().getGameTime() - (diff < 10L ? 10L - diff : 0L);
            } else {
                this.lastChangeTime = this.level().getGameTime();
            }
            this.lastState = state;
        }
        return this.lastChangeTime;
    }

    public IStorageBlockItemHandler getChestItemHandler(boolean override) {
        return ((Optional)FramedChestBlock.combine(this, override).apply(FramedChestBlock.CHEST_COMBINER)).orElse(null);
    }

    @Override
    public int getAnalogOutputSignal() {
        return FramedChestBlockEntity.getAnalogOutputSignal(this.getChestItemHandler(false));
    }

    @Override
    protected Component getDefaultName() {
        return TITLE;
    }

    @Override
    public AbstractContainerMenu createMenu(int windowId, Inventory inv, Player player) {
        IStorageBlockItemHandler handler = this.getChestItemHandler(false);
        return handler == null ? null : handler.createMenu(windowId, inv);
    }

    @Override
    public Component getDisplayName() {
        return (Component)FramedChestBlock.combine(this, true).apply(FramedChestBlock.TITLE_COMBINER);
    }

    @Override
    public void setBlockState(BlockState state) {
        BlockState oldState = this.getBlockState();
        super.setBlockState(state);
        if (state.getValue((Property)FramedProperties.FACING_HOR) != oldState.getValue((Property)FramedProperties.FACING_HOR) || state.getValue((Property)BlockStateProperties.CHEST_TYPE) != oldState.getValue((Property)BlockStateProperties.CHEST_TYPE)) {
            this.invalidateCapabilities();
        }
    }
}

