/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slopepanel;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.block.slopepanel.FramedFlatSlopePanelCornerBlock;
import xfacthd.framedblocks.common.blockentity.doubled.slopepanel.FramedFlatDoubleSlopePanelCornerBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.doubleblock.CamoGetter;
import xfacthd.framedblocks.common.data.doubleblock.DoubleBlockTopInteractionMode;
import xfacthd.framedblocks.common.data.doubleblock.SolidityCheck;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;

public class FramedFlatDoubleSlopePanelCornerBlock
extends AbstractFramedDoubleBlock {
    public FramedFlatDoubleSlopePanelCornerBlock() {
        super(BlockType.FRAMED_FLAT_DOUBLE_SLOPE_PANEL_CORNER);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)PropertyHolder.FRONT, (Comparable)Boolean.valueOf(false))).setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FramedProperties.FACING_HOR, PropertyHolder.ROTATION, PropertyHolder.FRONT, BlockStateProperties.WATERLOGGED, FramedProperties.Y_SLOPE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return FramedFlatSlopePanelCornerBlock.getStateForPlacement(this, true, context);
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        if (Utils.isY(face)) {
            return (BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)rot.rotate(dir));
        }
        if (face.getAxis() == dir.getAxis()) {
            HorizontalRotation rotation = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
            return (BlockState)state.setValue(PropertyHolder.ROTATION, (Comparable)((Object)rotation.rotate(rot)));
        }
        return (BlockState)state.cycle((Property)PropertyHolder.FRONT);
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return this.rotate(state, Direction.UP, rotation);
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return FramedFlatSlopePanelCornerBlock.mirrorCorner(state, mirror);
    }

    @Override
    public Tuple<BlockState, BlockState> calculateBlockPair(BlockState state) {
        Direction facing = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation rotation = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
        boolean front = (Boolean)state.getValue((Property)PropertyHolder.FRONT);
        HorizontalRotation backRot = rotation.rotate(rotation.isVertical() ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90);
        boolean ySlope = (Boolean)state.getValue((Property)FramedProperties.Y_SLOPE);
        return new Tuple((Object)((BlockState)((BlockState)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing)).setValue(PropertyHolder.ROTATION, (Comparable)((Object)rotation))).setValue((Property)PropertyHolder.FRONT, (Comparable)Boolean.valueOf(front))).setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))), (Object)((BlockState)((BlockState)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_FLAT_SLOPE_PANEL_CORNER.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing.getOpposite())).setValue(PropertyHolder.ROTATION, (Comparable)((Object)backRot))).setValue((Property)PropertyHolder.FRONT, (Comparable)Boolean.valueOf(!front))).setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))));
    }

    @Override
    public DoubleBlockTopInteractionMode calculateTopInteractionMode(BlockState state) {
        HorizontalRotation rotation = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
        if (rotation == HorizontalRotation.DOWN || rotation == HorizontalRotation.LEFT) {
            return DoubleBlockTopInteractionMode.FIRST;
        }
        return DoubleBlockTopInteractionMode.EITHER;
    }

    @Override
    public CamoGetter calculateCamoGetter(BlockState state, Direction side, @Nullable Direction edge) {
        Direction facing = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        boolean front = (Boolean)state.getValue((Property)PropertyHolder.FRONT);
        if (side == facing) {
            return front ? CamoGetter.NONE : CamoGetter.FIRST;
        }
        if (side == facing.getOpposite()) {
            return front ? CamoGetter.SECOND : CamoGetter.NONE;
        }
        HorizontalRotation rotation = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
        Direction rotDir = rotation.withFacing(facing);
        Direction perpRotDir = rotation.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(facing);
        if (side == rotDir || side == perpRotDir) {
            if (edge == facing && !front) {
                return CamoGetter.FIRST;
            }
            if (edge == facing.getOpposite() && front) {
                return CamoGetter.SECOND;
            }
        } else if (!front && edge == facing || front && edge == facing.getOpposite()) {
            return CamoGetter.FIRST;
        }
        return CamoGetter.NONE;
    }

    @Override
    public SolidityCheck calculateSolidityCheck(BlockState state, Direction side) {
        Direction facing = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        boolean front = (Boolean)state.getValue((Property)PropertyHolder.FRONT);
        if (side == facing && !front) {
            return SolidityCheck.FIRST;
        }
        if (side == facing.getOpposite() && front) {
            return SolidityCheck.SECOND;
        }
        return SolidityCheck.NONE;
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FramedFlatDoubleSlopePanelCornerBlockEntity(pos, state);
    }

    @Override
    public BlockState getItemModelSource() {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH)).setValue(PropertyHolder.ROTATION, (Comparable)((Object)HorizontalRotation.RIGHT));
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return (BlockState)this.defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }
}

