/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.pillar;

import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedLatticeBlock
extends FramedBlock {
    private final BiPredicate<Direction, BlockState> connectionTest;

    public FramedLatticeBlock(BlockType type) {
        super(type);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FramedProperties.X_AXIS, (Comparable)Boolean.valueOf(false))).setValue((Property)FramedProperties.Y_AXIS, (Comparable)Boolean.valueOf(false))).setValue((Property)FramedProperties.Z_AXIS, (Comparable)Boolean.valueOf(false))).setValue((Property)FramedProperties.STATE_LOCKED, (Comparable)Boolean.valueOf(false)));
        this.connectionTest = switch (type) {
            case BlockType.FRAMED_LATTICE_BLOCK -> FramedLatticeBlock::canConnectThin;
            case BlockType.FRAMED_THICK_LATTICE -> FramedLatticeBlock::canConnectThick;
            default -> throw new IllegalArgumentException("Unexpected lattice type: " + String.valueOf(type));
        };
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FramedProperties.X_AXIS, FramedProperties.Y_AXIS, FramedProperties.Z_AXIS, BlockStateProperties.WATERLOGGED, FramedProperties.STATE_LOCKED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return ((PlacementStateBuilder)((PlacementStateBuilder)PlacementStateBuilder.of(this, ctx).withCustom((state, modCtx) -> {
            BlockPos pos;
            Level level = modCtx.getLevel();
            state = (BlockState)state.setValue((Property)FramedProperties.X_AXIS, (Comparable)Boolean.valueOf(this.canConnectTo((LevelAccessor)level, pos = modCtx.getClickedPos(), Direction.EAST) || this.canConnectTo((LevelAccessor)level, pos, Direction.WEST)));
            state = (BlockState)state.setValue((Property)FramedProperties.Y_AXIS, (Comparable)Boolean.valueOf(this.canConnectTo((LevelAccessor)level, pos, Direction.UP) || this.canConnectTo((LevelAccessor)level, pos, Direction.DOWN)));
            state = (BlockState)state.setValue((Property)FramedProperties.Z_AXIS, (Comparable)Boolean.valueOf(this.canConnectTo((LevelAccessor)level, pos, Direction.NORTH) || this.canConnectTo((LevelAccessor)level, pos, Direction.SOUTH)));
            return state;
        })).withWater()).build();
    }

    @Override
    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (!((Boolean)state.getValue((Property)FramedProperties.STATE_LOCKED)).booleanValue()) {
            Direction opposite = facing.getOpposite();
            state = (BlockState)state.setValue((Property)FramedLatticeBlock.getPropFromAxis(facing), (Comparable)Boolean.valueOf(this.canConnectTo(facingState, facing) || this.canConnectTo(level, pos, opposite)));
        }
        return super.updateShape(state, facing, facingState, level, pos, facingPos);
    }

    private boolean canConnectTo(LevelAccessor level, BlockPos pos, Direction side) {
        BlockState state = level.getBlockState(pos.relative(side));
        return this.canConnectTo(state, side);
    }

    private boolean canConnectTo(BlockState state, Direction side) {
        return state.is((Block)this) || this.connectionTest.test(side, state);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        return state;
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        if (rot != Rotation.NONE && rot != Rotation.CLOCKWISE_180) {
            boolean xAxis = (Boolean)state.getValue((Property)FramedProperties.Z_AXIS);
            boolean zAxis = (Boolean)state.getValue((Property)FramedProperties.X_AXIS);
            return (BlockState)((BlockState)state.setValue((Property)FramedProperties.X_AXIS, (Comparable)Boolean.valueOf(xAxis))).setValue((Property)FramedProperties.Z_AXIS, (Comparable)Boolean.valueOf(zAxis));
        }
        return state;
    }

    @Override
    public BlockState getItemModelSource() {
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FramedProperties.X_AXIS, (Comparable)Boolean.valueOf(true))).setValue((Property)FramedProperties.Y_AXIS, (Comparable)Boolean.valueOf(true))).setValue((Property)FramedProperties.Z_AXIS, (Comparable)Boolean.valueOf(true));
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FramedProperties.X_AXIS, (Comparable)Boolean.valueOf(true))).setValue((Property)FramedProperties.Y_AXIS, (Comparable)Boolean.valueOf(true))).setValue((Property)FramedProperties.Z_AXIS, (Comparable)Boolean.valueOf(true));
    }

    public static BooleanProperty getPropFromAxis(Direction dir) {
        return switch (dir.getAxis()) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> FramedProperties.X_AXIS;
            case Direction.Axis.Y -> FramedProperties.Y_AXIS;
            case Direction.Axis.Z -> FramedProperties.Z_AXIS;
        };
    }

    private static boolean canConnectThin(Direction side, BlockState state) {
        if (state.is((Block)FBContent.BLOCK_FRAMED_POST.value())) {
            return side.getAxis() == state.getValue((Property)BlockStateProperties.AXIS);
        }
        return Utils.isY(side) && state.is(BlockTags.FENCES);
    }

    private static boolean canConnectThick(Direction side, BlockState state) {
        if (state.is(BlockTags.WALLS)) {
            return side == Direction.DOWN || side == Direction.UP && (Boolean)state.getValue((Property)BlockStateProperties.UP) != false;
        }
        if (state.is((Block)FBContent.BLOCK_FRAMED_PILLAR.value())) {
            return side.getAxis() == state.getValue((Property)BlockStateProperties.AXIS);
        }
        if (state.is((Block)FBContent.BLOCK_FRAMED_HALF_PILLAR.value())) {
            return side == ((Direction)state.getValue((Property)BlockStateProperties.FACING)).getOpposite();
        }
        return false;
    }
}

