/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.screen.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.util.ConcatenatedListView;
import xfacthd.framedblocks.client.screen.overlay.OverlayDisplayMode;

abstract class BlockInteractOverlay {
    private static final int LINE_DIST = 3;
    private static final Target NO_TARGET = new Target(BlockPos.ZERO, Blocks.AIR.defaultBlockState(), Direction.NORTH);
    private final String name;
    private final List<Component> linesFalse;
    private final List<Component> linesTrue;
    private final Texture textureFalse;
    private final Texture textureTrue;
    private final Supplier<OverlayDisplayMode> modeGetter;
    private int textWidth = 0;
    boolean textWidthValid = false;

    BlockInteractOverlay(String name, List<Component> linesFalse, List<Component> linesTrue, Texture textureFalse, Texture textureTrue, Supplier<OverlayDisplayMode> modeGetter) {
        this.name = name;
        this.linesFalse = linesFalse;
        this.linesTrue = linesTrue;
        this.textureFalse = textureFalse;
        this.textureTrue = textureTrue;
        this.modeGetter = modeGetter;
    }

    boolean render(GuiGraphics graphics) {
        OverlayDisplayMode mode = this.modeGetter.get();
        if (mode == OverlayDisplayMode.HIDDEN || BlockInteractOverlay.player().isSpectator() || Minecraft.getInstance().options.hideGui) {
            return false;
        }
        ItemStack stack = BlockInteractOverlay.player().getMainHandItem();
        if (!this.isValidTool(stack)) {
            return false;
        }
        Target target = BlockInteractOverlay.getTargettedBlock();
        if (!this.isValidTarget(target)) {
            return false;
        }
        boolean state = this.getState(target);
        int screenWidth = graphics.guiWidth();
        int screenHeight = graphics.guiHeight();
        int centerX = screenWidth / 2;
        int centerY = screenHeight / 2;
        Texture tex = this.getTexture(target, state, this.textureFalse, this.textureTrue);
        int texX = centerX + 20;
        int texY = centerY - tex.height / 2;
        tex.draw(graphics, texX, texY);
        this.renderAfterIcon(graphics, tex, texX, texY, target);
        if (mode == OverlayDisplayMode.DETAILED) {
            List<Component> lines = this.getLines(target, state, this.linesFalse, this.linesTrue);
            this.renderDetailed(graphics, tex, lines, centerX, screenHeight, target);
        }
        return true;
    }

    private void renderDetailed(GuiGraphics graphics, Texture tex, List<Component> lines, int centerX, int screenHeight, Target target) {
        Font font = Minecraft.getInstance().font;
        if (!this.textWidthValid) {
            this.updateTextWidth(font);
        }
        Objects.requireNonNull(font);
        int lineHeight = 9 + 3;
        int count = lines.size();
        int contentHeight = count * lineHeight - 3;
        int width = this.textWidth + tex.width + 10;
        int height = Math.max(contentHeight, tex.height);
        int x = centerX - width / 2;
        int y = screenHeight - 80 - height;
        BlockInteractOverlay.drawTooltipBackground(graphics, x, y, width, height);
        int textX = x + tex.width + 10;
        int yBaseOff = tex.height > contentHeight ? (tex.height - contentHeight) / 2 : 0;
        for (int i = 0; i < count; ++i) {
            Component text = lines.get(i);
            int yOff = yBaseOff + lineHeight * i;
            graphics.drawString(font, text, textX, y + yOff, -1);
        }
        int texY = y + height / 2 - tex.height / 2;
        tex.draw(graphics, x, texY);
        this.renderAfterIcon(graphics, tex, x, texY, target);
    }

    protected abstract boolean isValidTool(ItemStack var1);

    protected abstract boolean isValidTarget(Target var1);

    protected abstract boolean getState(Target var1);

    protected Texture getTexture(Target target, boolean state, Texture texFalse, Texture texTrue) {
        return state ? texTrue : texFalse;
    }

    protected List<Component> getLines(Target target, boolean state, List<Component> linesFalse, List<Component> linesTrue) {
        return state ? linesTrue : linesFalse;
    }

    protected void renderAfterIcon(GuiGraphics graphics, Texture tex, int texX, int texY, Target target) {
    }

    private void updateTextWidth(Font font) {
        this.textWidth = 0;
        for (Component line : ConcatenatedListView.of((List[])new List[]{this.linesFalse, this.linesTrue})) {
            this.textWidth = Math.max(this.textWidth, font.width((FormattedText)line));
        }
        this.textWidthValid = true;
    }

    final String getName() {
        return this.name;
    }

    protected static BlockGetter level() {
        return (BlockGetter)Objects.requireNonNull(Minecraft.getInstance().level);
    }

    protected static Player player() {
        return (Player)Objects.requireNonNull(Minecraft.getInstance().player);
    }

    protected static Target getTargettedBlock() {
        HitResult hit = Minecraft.getInstance().hitResult;
        if (hit instanceof BlockHitResult) {
            BlockHitResult blockHit = (BlockHitResult)hit;
            BlockPos pos = blockHit.getBlockPos();
            return new Target(pos, BlockInteractOverlay.level().getBlockState(pos), blockHit.getDirection());
        }
        return NO_TARGET;
    }

    private static void drawTooltipBackground(GuiGraphics graphics, int x, int y, int width, int height) {
        graphics.drawManaged(() -> TooltipRenderUtil.renderTooltipBackground((GuiGraphics)graphics, (int)(x - 2), (int)(y - 2), (int)(width + 4), (int)(height + 4), (int)0));
    }

    protected record Texture(ResourceLocation location, int xOff, int yOff, int width, int height, int texWidth, int texHeight) {
        public void draw(GuiGraphics graphics, int x, int y) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableDepthTest();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            graphics.blit(this.location, x, y, 0, (float)this.xOff, (float)this.yOff, this.width, this.height, this.texWidth, this.texHeight);
        }
    }

    protected record Target(BlockPos pos, BlockState state, Direction side) {
    }
}

