/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.render.util;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.atlas.SpriteResourceLoader;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.SpriteSourceType;
import net.minecraft.client.renderer.texture.atlas.sources.LazyLoadedImage;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceMetadata;
import net.minecraft.util.ExtraCodecs;
import xfacthd.framedblocks.FramedBlocks;
import xfacthd.framedblocks.client.util.NoAnimationResourceMetadata;

public record AnimationSplitterSource(ResourceLocation resource, List<Frame> frames) implements SpriteSource
{
    private static final MapCodec<AnimationSplitterSource> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)ResourceLocation.CODEC.fieldOf("resource").forGetter(s -> s.resource), (App)ExtraCodecs.nonEmptyList((Codec)Frame.CODEC.listOf()).fieldOf("frames").forGetter(s -> s.frames)).apply((Applicative)inst, AnimationSplitterSource::new));
    public static final SpriteSourceType TYPE = new SpriteSourceType(CODEC);

    public void run(ResourceManager mgr, SpriteSource.Output out) {
        ResourceLocation texPath = TEXTURE_ID_CONVERTER.idToFile(this.resource);
        Optional optResource = mgr.getResource(texPath);
        if (optResource.isPresent()) {
            Resource res = (Resource)optResource.get();
            LazyLoadedImage image = new LazyLoadedImage(texPath, res, this.frames.size());
            this.frames.forEach(frame -> out.add(frame.outLoc, (SpriteSource.SpriteSupplier)new FrameInstance(res, texPath, image, (Frame)frame)));
        } else {
            FramedBlocks.LOGGER.warn("Missing sprite: {}", (Object)texPath);
        }
    }

    public SpriteSourceType type() {
        return TYPE;
    }

    public record Frame(int frameIdx, ResourceLocation outLoc) {
        private static final Codec<Frame> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("frame_idx").forGetter(Frame::frameIdx), (App)ResourceLocation.CODEC.fieldOf("sprite").forGetter(Frame::outLoc)).apply((Applicative)inst, Frame::new));
    }

    public record FrameInstance(Resource resource, ResourceLocation texPath, LazyLoadedImage lazyImage, Frame frame) implements SpriteSource.SpriteSupplier
    {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SpriteContents apply(SpriteResourceLoader loader) {
            try {
                ResourceMetadata srcMeta = this.resource.metadata();
                Optional optAnim = srcMeta.getSection((MetadataSectionSerializer)AnimationMetadataSection.SERIALIZER);
                if (optAnim.isEmpty()) {
                    throw new IllegalArgumentException("Texture '%s' is not an animated texture".formatted(this.texPath));
                }
                NativeImage image = this.lazyImage.get();
                int imgW = image.getWidth();
                int imgH = image.getHeight();
                AnimationMetadataSection anim = (AnimationMetadataSection)optAnim.get();
                FrameSize size = anim.calculateFrameSize(imgW, imgH);
                int frameW = size.width();
                int frameH = size.height();
                int frameCount = imgW / frameW * (imgH / frameH);
                FrameInstance.checkFrameExists(this.texPath, anim, this.frame.frameIdx, frameCount);
                int srcX = this.frame.frameIdx % frameCount * frameW;
                int srcY = this.frame.frameIdx / frameCount * frameH;
                NativeImage imageOut = new NativeImage(NativeImage.Format.RGBA, frameW, frameH, false);
                image.copyRect(imageOut, srcX, srcY, 0, 0, frameW, frameH, false, false);
                SpriteContents spriteContents = new SpriteContents(this.frame.outLoc, new FrameSize(frameW, frameH), imageOut, (ResourceMetadata)new NoAnimationResourceMetadata(srcMeta));
                return spriteContents;
            }
            catch (Exception e) {
                FramedBlocks.LOGGER.error("Failed to split out frame {}", (Object)this.frame, (Object)e);
            }
            finally {
                this.lazyImage.release();
            }
            return MissingTextureAtlasSprite.create();
        }

        private static void checkFrameExists(ResourceLocation texPath, AnimationMetadataSection anim, int frameIdx, int frameCount) {
            boolean[] frameFound = new boolean[1];
            int[] maxIdx = new int[]{-1};
            anim.forEachFrame((idx, time) -> {
                maxIdx[0] = Math.max(maxIdx[0], idx);
                if (idx == frameIdx) {
                    frameFound[0] = true;
                }
            });
            if (!(frameFound[0] || maxIdx[0] == -1 && frameIdx < frameCount)) {
                int max = maxIdx[0] != -1 ? maxIdx[0] : frameCount;
                throw new IllegalArgumentException("Texture '%s' has no frame with index %d, max index is %d".formatted(texPath, frameIdx, max));
            }
        }

        public void discard() {
            this.lazyImage.release();
        }
    }
}

