/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.overlaygen;

import java.util.Arrays;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import org.joml.Vector3f;

record OverlayCacheKey(Direction face, int[] keyData, TextureAtlasSprite sprite) {
    public void pos(int vert, Vector3f out) {
        int offset = vert * 4;
        out.set(Float.intBitsToFloat(this.keyData[offset]), Float.intBitsToFloat(this.keyData[offset + 1]), Float.intBitsToFloat(this.keyData[offset + 2]));
    }

    public void normal(int vert, Vector3f out) {
        int offset = vert * 4 + 3;
        int packedNormal = this.keyData[offset];
        out.set((float)((byte)(packedNormal & 0xFF)) / 127.0f, (float)((byte)(packedNormal >> 8 & 0xFF)) / 127.0f, (float)((byte)(packedNormal >> 16 & 0xFF)) / 127.0f);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OverlayCacheKey key = (OverlayCacheKey)o;
        return this.face == key.face && Arrays.equals(this.keyData, key.keyData) && this.sprite == key.sprite;
    }

    @Override
    public int hashCode() {
        int result = this.face.hashCode();
        result = 31 * result + Arrays.hashCode(this.keyData);
        result = 31 * result + this.sprite.hashCode();
        return result;
    }
}

