/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.stairs;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.Utils;

public class FramedVerticalHalfStairsGeometry
extends Geometry {
    private final Direction dir;
    private final boolean top;

    public FramedVerticalHalfStairsGeometry(GeometryFactory.Context ctx) {
        this.dir = (Direction)ctx.state().getValue((Property)FramedProperties.FACING_HOR);
        this.top = (Boolean)ctx.state().getValue((Property)FramedProperties.TOP);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        if (quadDir == this.dir.getOpposite() || quadDir == this.dir.getClockWise()) {
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(quadDir == this.dir.getOpposite() ? this.dir.getClockWise() : this.dir.getOpposite(), 0.5f)).apply(Modifiers.cutSideUpDown(this.top, 0.5f)).export(quadMap.get(quadDir));
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(quadDir == this.dir.getOpposite() ? this.dir.getCounterClockWise() : this.dir, 0.5f)).apply(Modifiers.cutSideUpDown(this.top, 0.5f)).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
        } else if (quadDir == this.dir || quadDir == this.dir.getCounterClockWise()) {
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(this.top, 0.5f)).export(quadMap.get(quadDir));
        } else if (Utils.isY(quadDir)) {
            boolean inset = quadDir == Direction.UP != this.top;
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getOpposite(), 0.5f)).applyIf(Modifiers.setPosition(0.5f), inset).export(quadMap.get(inset ? null : quadDir));
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir, 0.5f)).apply(Modifiers.cutTopBottom(this.dir.getClockWise(), 0.5f)).applyIf(Modifiers.setPosition(0.5f), inset).export(quadMap.get(inset ? null : quadDir));
        }
    }
}

