/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.rail;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.joml.Vector3f;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.Utils;

public class FramedFancyRailGeometry
extends Geometry {
    private static final int SLEEPER_COUNT = 4;
    private static final int SLEEPER_COUNT_CURVE = 3;
    private static final float SLEEPER_BASE_OFFSET = 0.0625f;
    private static final float SLEEPER_DIST = 0.25f;
    private static final float SLEEPER_DIST_CURVE = 0.375f;
    private static final float SLEEPER_WIDTH = 0.125f;
    private static final float SLEEPER_HEIGHT = 0.0625f;
    private static final float SLEEPER_DIAGONAL_OFFSET = 0.115625f;
    private static final Vector3f SCALE_X = new Vector3f(1.0f, 0.0f, 0.0f);
    private static final Vector3f SCALE_Z = new Vector3f(0.0f, 0.0f, 1.0f);
    private static final Vector3f[] SLOPE_ORIGINS = (Vector3f[])Util.make((Object)new Vector3f[4], arr -> {
        arr[Direction.NORTH.get2DDataValue()] = new Vector3f(0.0f, 0.0f, 1.0f);
        arr[Direction.EAST.get2DDataValue()] = new Vector3f(0.0f, 0.0f, 0.0f);
        arr[Direction.SOUTH.get2DDataValue()] = new Vector3f(0.0f, 0.0f, 0.0f);
        arr[Direction.WEST.get2DDataValue()] = new Vector3f(1.0f, 0.0f, 0.0f);
    });
    private final BlockState state;
    private final BakedModel baseModel;
    private final RailShape shape;
    private final Direction mainDir;
    private final Direction secDir;

    private FramedFancyRailGeometry(GeometryFactory.Context ctx, Property<RailShape> shapeProperty) {
        this.state = ctx.state();
        this.baseModel = ctx.baseModel();
        this.shape = (RailShape)this.state.getValue(shapeProperty);
        this.mainDir = FramedFancyRailGeometry.getDirectionFromRailShape(this.shape);
        this.secDir = FramedFancyRailGeometry.getSecondaryDirectionFromRailShape(this.shape);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Pair<List<BakedQuad>, Direction> result = this.shape.isAscending() ? FramedFancyRailGeometry.makeAscendingRailSleepers(quad, this.mainDir) : (this.shape == RailShape.NORTH_SOUTH || this.shape == RailShape.EAST_WEST ? FramedFancyRailGeometry.makeStraightRailSleepers(quad, this.mainDir) : FramedFancyRailGeometry.makeCurvedRailSleepers(quad, this.mainDir, this.secDir));
        quadMap.get((Direction)result.getSecond()).addAll((Collection)result.getFirst());
    }

    private static Pair<List<BakedQuad>, Direction> makeStraightRailSleepers(BakedQuad quad, Direction dir) {
        Direction targetDir;
        ArrayList result = new ArrayList(4);
        Direction quadDir = quad.getDirection();
        if (Utils.isY(quadDir)) {
            targetDir = quadDir == Direction.UP ? null : quadDir;
            FramedFancyRailGeometry.forAllSleepers((i, distDir, distOpp) -> QuadModifier.of(quad).apply(Modifiers.cutTopBottom(dir, distDir)).apply(Modifiers.cutTopBottom(dir.getOpposite(), distOpp)).applyIf(Modifiers.setPosition(0.0625f), quadDir == Direction.UP).export(result));
        } else if (quadDir.getAxis() == dir.getAxis()) {
            targetDir = null;
            FramedFancyRailGeometry.forAllSleepers((i, distDir, distOpp) -> QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(false, 0.0625f)).apply(Modifiers.setPosition(distDir)).export(result));
        } else {
            targetDir = quadDir;
            FramedFancyRailGeometry.forAllSleepers((i, distDir, distOpp) -> QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(false, 0.0625f)).apply(Modifiers.cutSideLeftRight(dir, distDir)).apply(Modifiers.cutSideLeftRight(dir.getOpposite(), distOpp)).export(result));
        }
        return Pair.of(result, (Object)targetDir);
    }

    private static Pair<List<BakedQuad>, Direction> makeAscendingRailSleepers(BakedQuad quad, Direction dir) {
        Pair<List<BakedQuad>, Direction> result = FramedFancyRailGeometry.makeStraightRailSleepers(quad, dir);
        Direction.Axis axis = dir.getClockWise().getAxis();
        Vector3f origin = SLOPE_ORIGINS[dir.get2DDataValue()];
        float angle = Utils.isPositive(dir) == Utils.isX(dir) ? 45.0f : -45.0f;
        Vector3f scaleVec = Utils.isX(dir) ? SCALE_X : SCALE_Z;
        List quads = (List)result.getFirst();
        for (BakedQuad resultQuad : quads) {
            QuadModifier.of(resultQuad).apply(Modifiers.rotate(axis, origin, angle, true, scaleVec)).modifyInPlace();
        }
        Direction targetDir = result.getSecond() == Direction.DOWN ? null : (Direction)result.getSecond();
        return Pair.of((Object)quads, (Object)targetDir);
    }

    private static Pair<List<BakedQuad>, Direction> makeCurvedRailSleepers(BakedQuad quad, Direction dir, Direction secDir) {
        Direction targetDir;
        ArrayList result = new ArrayList(3);
        Direction quadDir = quad.getDirection();
        if (Utils.isY(quadDir)) {
            targetDir = quadDir == Direction.UP ? null : quadDir;
            FramedFancyRailGeometry.forAllSleepersCurve((i, distDir, distOpp) -> {
                boolean nonDiagUp = quadDir == Direction.UP && i != 1;
                float height = nonDiagUp ? 0.0615f : 0.0625f;
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(dir, distDir)).apply(Modifiers.cutTopBottom(dir.getOpposite(), distOpp)).applyIf(Modifiers.setPosition(height), quadDir == Direction.UP).applyIf(FramedFancyRailGeometry.rotateCurveSleeper(dir, secDir, i), i < 2).applyIf(Modifiers.offset(dir, 0.115625f), i == 1).applyIf(Modifiers.offset(secDir, 0.115625f), i == 1).export(result);
            });
        } else if (quadDir.getAxis() == dir.getAxis()) {
            targetDir = null;
            boolean inDir = quadDir == dir;
            FramedFancyRailGeometry.forAllSleepersCurve((i, distDir, distOpp) -> QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(false, 0.0625f)).apply(Modifiers.setPosition(inDir ? distDir : distOpp)).applyIf(FramedFancyRailGeometry.rotateCurveSleeper(dir, secDir, i), i < 2).applyIf(Modifiers.offset(dir, 0.115625f), i == 1).applyIf(Modifiers.offset(secDir, 0.115625f), i == 1).export(result));
        } else {
            targetDir = quadDir;
            FramedFancyRailGeometry.forAllSleepersCurve((i, distDir, distOpp) -> QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(false, 0.0625f)).apply(Modifiers.cutSideLeftRight(dir, distDir)).apply(Modifiers.cutSideLeftRight(dir.getOpposite(), distOpp)).applyIf(FramedFancyRailGeometry.rotateCurveSleeper(dir, secDir, i), i < 2).applyIf(Modifiers.offset(dir, 0.115625f), i == 1).applyIf(Modifiers.offset(secDir, 0.115625f), i == 1).export(result));
        }
        return Pair.of(result, (Object)targetDir);
    }

    private static QuadModifier.Modifier rotateCurveSleeper(Direction dir, Direction secDir, int i) {
        float angle = 45.0f * (float)(2 - i);
        if (secDir == dir.getCounterClockWise()) {
            angle *= -1.0f;
        }
        return Modifiers.rotateCentered(Direction.Axis.Y, angle, false);
    }

    private static void forAllSleepers(SleeperConsumer consumer) {
        for (int i = 0; i < 4; ++i) {
            float distDir = 0.0625f + (float)i * 0.25f + 0.125f;
            float distOpp = 1.0f - distDir + 0.125f;
            consumer.accept(i, distDir, distOpp);
        }
    }

    private static void forAllSleepersCurve(SleeperConsumer consumer) {
        for (int i = 0; i < 3; ++i) {
            float distDir = 0.0625f + (float)i * 0.375f + 0.125f;
            float distOpp = 1.0f - distDir + 0.125f;
            consumer.accept(i, distDir, distOpp);
        }
    }

    @Override
    public ChunkRenderTypeSet getAdditionalRenderTypes(RandomSource rand, ModelData extraData) {
        return this.baseModel.getRenderTypes(this.state, rand, extraData);
    }

    @Override
    public void getAdditionalQuads(QuadMap quadMap, RandomSource rand, ModelData data, RenderType renderType) {
        Utils.forAllDirections(dir -> quadMap.get((Direction)dir).addAll(this.baseModel.getQuads(this.state, dir, rand, data, renderType)));
    }

    @Override
    public boolean useSolidNoCamoModel() {
        return true;
    }

    public static Direction getDirectionFromRailShape(RailShape shape) {
        return switch (shape) {
            default -> throw new MatchException(null, null);
            case RailShape.NORTH_SOUTH -> Direction.NORTH;
            case RailShape.EAST_WEST -> Direction.EAST;
            case RailShape.ASCENDING_NORTH -> Direction.NORTH;
            case RailShape.ASCENDING_EAST -> Direction.EAST;
            case RailShape.ASCENDING_SOUTH -> Direction.SOUTH;
            case RailShape.ASCENDING_WEST -> Direction.WEST;
            case RailShape.NORTH_EAST, RailShape.NORTH_WEST -> Direction.NORTH;
            case RailShape.SOUTH_EAST, RailShape.SOUTH_WEST -> Direction.SOUTH;
        };
    }

    private static Direction getSecondaryDirectionFromRailShape(RailShape shape) {
        return switch (shape) {
            case RailShape.NORTH_EAST, RailShape.SOUTH_EAST -> Direction.EAST;
            case RailShape.NORTH_WEST, RailShape.SOUTH_WEST -> Direction.WEST;
            default -> null;
        };
    }

    public static FramedFancyRailGeometry normal(GeometryFactory.Context ctx) {
        return new FramedFancyRailGeometry(ctx, (Property<RailShape>)BlockStateProperties.RAIL_SHAPE);
    }

    public static FramedFancyRailGeometry straight(GeometryFactory.Context ctx) {
        return new FramedFancyRailGeometry(ctx, (Property<RailShape>)BlockStateProperties.RAIL_SHAPE_STRAIGHT);
    }

    @FunctionalInterface
    public static interface SleeperConsumer {
        public void accept(int var1, float var2, float var3);
    }
}

