/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.util.Utils;

public final class QuadTable
implements QuadMap {
    private static final int LAYER_COUNT = RenderType.chunkBufferLayers().size();
    private static final int SIDE_COUNT = Direction.values().length + 1;
    private static final List<BakedQuad> EMPTY = List.of();
    private final ArrayList<BakedQuad>[] quads = new ArrayList[LAYER_COUNT * SIDE_COUNT];
    private int boundBaseIdx = -1;

    public List<BakedQuad> getQuads(RenderType renderType, Direction side) {
        int idx = renderType.getChunkLayerId() * SIDE_COUNT + Utils.maskNullDirection(side);
        return Objects.requireNonNullElse(this.quads[idx], EMPTY);
    }

    public List<BakedQuad> getAllQuads(Direction side) {
        ArrayList<BakedQuad> allQuads = new ArrayList<BakedQuad>(LAYER_COUNT);
        int sideIdx = Utils.maskNullDirection(side);
        for (int i = 0; i < LAYER_COUNT; ++i) {
            int idx = i * SIDE_COUNT + sideIdx;
            ArrayList<BakedQuad> layerQuads = this.quads[idx];
            if (layerQuads == null || layerQuads.isEmpty()) continue;
            Utils.copyAll(layerQuads, allQuads);
        }
        return allQuads;
    }

    @Override
    public ArrayList<BakedQuad> get(Direction side) {
        Preconditions.checkState((this.boundBaseIdx > -1 ? 1 : 0) != 0, (Object)"No RenderType bound");
        return this.quads[this.boundBaseIdx + Utils.maskNullDirection(side)];
    }

    @Override
    public ArrayList<BakedQuad> put(Direction side, ArrayList<BakedQuad> quadList) {
        Preconditions.checkState((this.boundBaseIdx > -1 ? 1 : 0) != 0, (Object)"No RenderType bound");
        int idx = this.boundBaseIdx + Utils.maskNullDirection(side);
        ArrayList<BakedQuad> oldList = this.quads[idx];
        this.quads[idx] = quadList;
        return oldList;
    }

    public void initializeForLayer(RenderType renderType) {
        Objects.requireNonNull(renderType, "Can't initialize for null layer");
        this.bindRenderType(renderType);
        int end = this.boundBaseIdx + SIDE_COUNT;
        for (int i = this.boundBaseIdx; i < end; ++i) {
            if (this.quads[i] != null) continue;
            this.quads[i] = new ArrayList();
        }
    }

    public void bindRenderType(RenderType renderType) {
        this.boundBaseIdx = renderType != null ? renderType.getChunkLayerId() * SIDE_COUNT : -1;
    }

    public void trim() {
        for (int i = 0; i < this.quads.length; ++i) {
            ArrayList<BakedQuad> list = this.quads[i];
            if (list == null || !list.isEmpty()) continue;
            this.quads[i] = null;
        }
    }
}

