/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.model.wrapping.itemmodel;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Predicate;
import net.minecraft.world.item.ItemDisplayContext;
import xfacthd.framedblocks.api.model.wrapping.itemmodel.ItemModelInfo;
import xfacthd.framedblocks.api.util.Utils;

public final class TranslatedItemModelInfo
implements ItemModelInfo {
    public static final TranslatedItemModelInfo HAND_Y_HALF_UP = TranslatedItemModelInfo.hand(0.0f, 0.5f, 0.0f);
    private final Predicate<ItemDisplayContext> ctxSelector;
    private final float tx;
    private final float ty;
    private final float tz;

    public TranslatedItemModelInfo(Predicate<ItemDisplayContext> ctxSelector, float tx, float ty, float tz) {
        this.ctxSelector = ctxSelector;
        this.tx = tx;
        this.ty = ty;
        this.tz = tz;
    }

    @Override
    public void applyItemTransform(PoseStack poseStack, ItemDisplayContext ctx, boolean leftHand) {
        if (this.ctxSelector.test(ctx)) {
            poseStack.translate(this.tx, this.ty, this.tz);
        }
    }

    public static TranslatedItemModelInfo hand(float tx, float ty, float tz) {
        return new TranslatedItemModelInfo(Utils::isHandContext, tx, ty, tz);
    }

    public static TranslatedItemModelInfo handOrGui(float tx, float ty, float tz) {
        return new TranslatedItemModelInfo(ctx -> Utils.isHandContext(ctx) || ctx == ItemDisplayContext.GUI, tx, ty, tz);
    }

    public static TranslatedItemModelInfo handGuiOrFixed(float tx, float ty, float tz) {
        return new TranslatedItemModelInfo(ctx -> Utils.isHandContext(ctx) || ctx == ItemDisplayContext.GUI || ctx == ItemDisplayContext.FIXED, tx, ty, tz);
    }
}

